/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FunctionUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.NormalizationUtil;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.manager.UnsupportedFeatureException;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static FieldValue evaluate(FieldName name, EvaluationContext context) {
        Map.Entry<FieldName, FieldValue> entry = context.getFieldEntry(name);
        if (entry == null) {
            DerivedField derivedField = context.resolveDerivedField(name);
            if (derivedField == null) {
                return null;
            }
            FieldValue value = ExpressionUtil.evaluate(derivedField, context);
            context.declare(name, value);
            return value;
        }
        return entry.getValue();
    }

    public static FieldValue evaluate(DerivedField derivedField, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(derivedField.getExpression(), context);
        return FieldValueUtil.refine(derivedField, value);
    }

    public static FieldValue evaluate(Expression expression, EvaluationContext context) {
        if (expression instanceof Constant) {
            return ExpressionUtil.evaluateConstant((Constant)expression, context);
        }
        if (expression instanceof FieldRef) {
            return ExpressionUtil.evaluateFieldRef((FieldRef)expression, context);
        }
        if (expression instanceof NormContinuous) {
            return ExpressionUtil.evaluateNormContinuous((NormContinuous)expression, context);
        }
        if (expression instanceof NormDiscrete) {
            return ExpressionUtil.evaluateNormDiscrete((NormDiscrete)expression, context);
        }
        if (expression instanceof Discretize) {
            return ExpressionUtil.evaluateDiscretize((Discretize)expression, context);
        }
        if (expression instanceof MapValues) {
            return ExpressionUtil.evaluateMapValues((MapValues)expression, context);
        }
        if (expression instanceof Apply) {
            return ExpressionUtil.evaluateApply((Apply)expression, context);
        }
        if (expression instanceof Aggregate) {
            return ExpressionUtil.evaluateAggregate((Aggregate)expression, context);
        }
        throw new UnsupportedFeatureException(expression);
    }

    public static FieldValue evaluateConstant(Constant constant, EvaluationContext context) {
        String value = constant.getValue();
        DataType dataType = constant.getDataType();
        if (dataType == null) {
            dataType = TypeUtil.getConstantDataType(value);
        }
        return FieldValueUtil.create(dataType, null, value);
    }

    public static FieldValue evaluateFieldRef(FieldRef fieldRef, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(fieldRef.getField(), context);
        if (value == null) {
            return FieldValueUtil.create(fieldRef.getMapMissingTo());
        }
        return value;
    }

    public static FieldValue evaluateNormContinuous(NormContinuous normContinuous, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(normContinuous.getField(), context);
        if (value == null) {
            return FieldValueUtil.create(normContinuous.getMapMissingTo());
        }
        return NormalizationUtil.normalize(normContinuous, value);
    }

    public static FieldValue evaluateNormDiscrete(NormDiscrete normDiscrete, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(normDiscrete.getField(), context);
        if (value == null) {
            return FieldValueUtil.create(normDiscrete.getMapMissingTo());
        }
        boolean equals = value.equalsString(normDiscrete.getValue());
        return FieldValueUtil.create(equals ? 1.0 : 0.0);
    }

    public static FieldValue evaluateDiscretize(Discretize discretize, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(discretize.getField(), context);
        if (value == null) {
            return FieldValueUtil.create(discretize.getDataType(), null, discretize.getMapMissingTo());
        }
        return DiscretizationUtil.discretize(discretize, value);
    }

    public static FieldValue evaluateMapValues(MapValues mapValues, EvaluationContext context) {
        LinkedHashMap<String, FieldValue> values = Maps.newLinkedHashMap();
        List<FieldColumnPair> fieldColumnPairs = mapValues.getFieldColumnPairs();
        for (FieldColumnPair fieldColumnPair : fieldColumnPairs) {
            FieldValue value = ExpressionUtil.evaluate(fieldColumnPair.getField(), context);
            if (value == null) {
                return FieldValueUtil.create(mapValues.getDataType(), null, mapValues.getMapMissingTo());
            }
            values.put(fieldColumnPair.getColumn(), value);
        }
        return DiscretizationUtil.mapValue(mapValues, values);
    }

    public static FieldValue evaluateApply(Apply apply, EvaluationContext context) {
        FieldValue result;
        ArrayList<FieldValue> values = Lists.newArrayList();
        List<Expression> arguments = apply.getExpressions();
        for (Expression argument : arguments) {
            FieldValue value = ExpressionUtil.evaluate(argument, context);
            values.add(value);
        }
        try {
            result = FunctionUtil.evaluate(apply, values, context);
        }
        catch (InvalidResultException ire) {
            InvalidValueTreatmentMethodType invalidValueTreatmentMethod = apply.getInvalidValueTreatment();
            switch (invalidValueTreatmentMethod) {
                case RETURN_INVALID: {
                    throw new InvalidResultException(apply);
                }
                case AS_IS: {
                    throw ire;
                }
                case AS_MISSING: {
                    return FieldValueUtil.create(apply.getMapMissingTo());
                }
            }
            throw new UnsupportedFeatureException(apply, invalidValueTreatmentMethod);
        }
        if (result == null) {
            return FieldValueUtil.create(apply.getMapMissingTo());
        }
        return result;
    }

    public static FieldValue evaluateAggregate(Aggregate aggregate, EvaluationContext context) {
        ArrayList values;
        FieldValue value = ExpressionUtil.evaluate(aggregate.getField(), context);
        try {
            values = (ArrayList)FieldValueUtil.getValue(value);
        }
        catch (ClassCastException cce) {
            throw new TypeCheckException(Collection.class, value);
        }
        FieldName groupName = aggregate.getGroupField();
        if (groupName != null) {
            FieldValue groupValue = ExpressionUtil.evaluate(groupName, context);
            TypeUtil.getDataType(FieldValueUtil.getValue(groupValue));
        }
        values = Lists.newArrayList(Iterables.filter(values, Predicates.notNull()));
        Aggregate.Function function = aggregate.getFunction();
        switch (function) {
            case COUNT: {
                return FieldValueUtil.create(values.size());
            }
            case SUM: {
                return FunctionUtil.evaluate(new Apply("sum"), ExpressionUtil.createValues(values), context);
            }
            case AVERAGE: {
                return FunctionUtil.evaluate(new Apply("avg"), ExpressionUtil.createValues(values), context);
            }
            case MIN: {
                return FieldValueUtil.create(Collections.min(values));
            }
            case MAX: {
                return FieldValueUtil.create(Collections.max(values));
            }
        }
        throw new UnsupportedFeatureException(aggregate, function);
    }

    private static List<FieldValue> createValues(Collection<?> values) {
        Function<Object, FieldValue> function = new Function<Object, FieldValue>(){

            @Override
            public FieldValue apply(Object value) {
                return FieldValueUtil.create(value);
            }
        };
        return Lists.newArrayList(Iterables.transform(values, function));
    }
}

