/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.manager.ModelManager;

public class ModelEvaluationContext
extends EvaluationContext {
    private ModelManager<?> modelManager = null;
    private ModelEvaluationContext parent = null;

    public ModelEvaluationContext(ModelManager<?> modelManager) {
        this(modelManager, null);
    }

    public ModelEvaluationContext(ModelManager<?> modelManager, ModelEvaluationContext parent) {
        this.setModelManager(modelManager);
        this.setParent(parent);
    }

    @Override
    public Map.Entry<FieldName, FieldValue> getFieldEntry(FieldName name) {
        Map.Entry<FieldName, FieldValue> entry = super.getFieldEntry(name);
        if (entry == null) {
            ModelEvaluationContext parent = this.getParent();
            if (parent != null) {
                return parent.getFieldEntry(name);
            }
            return null;
        }
        return entry;
    }

    @Override
    public DerivedField resolveDerivedField(FieldName name) {
        ModelManager<?> modelManager = this.getModelManager();
        DerivedField derivedField = modelManager.getLocalDerivedField(name);
        if (derivedField == null) {
            ModelEvaluationContext parent = this.getParent();
            if (parent != null) {
                return parent.resolveDerivedField(name);
            }
            return modelManager.getDerivedField(name);
        }
        return derivedField;
    }

    @Override
    public DefineFunction resolveFunction(String name) {
        ModelManager<?> modelManager = this.getModelManager();
        return modelManager.getFunction(name);
    }

    @Override
    public FieldValue createFieldValue(FieldName name, Object value) {
        ModelManager<?> modelManager = this.getModelManager();
        DataField dataField = modelManager.getDataField(name);
        if (dataField != null) {
            return FieldValueUtil.create(dataField, value);
        }
        return super.createFieldValue(name, value);
    }

    public ModelManager<?> getModelManager() {
        return this.modelManager;
    }

    private void setModelManager(ModelManager<?> modelManager) {
        this.modelManager = modelManager;
    }

    public ModelEvaluationContext getParent() {
        return this.parent;
    }

    private void setParent(ModelEvaluationContext parent) {
        this.parent = parent;
    }
}

