/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Attribute;
import org.dmg.pmml.Characteristic;
import org.dmg.pmml.Characteristics;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Scorecard;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.ScoreClassificationMap;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.VoteCounter;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class ScorecardEvaluator
extends ModelEvaluator<Scorecard> {
    public ScorecardEvaluator(PMML pmml) {
        this(pmml, ScorecardEvaluator.find(pmml.getModels(), Scorecard.class));
    }

    public ScorecardEvaluator(PMML pmml, Scorecard scorecard) {
        super(pmml, scorecard);
    }

    @Override
    public String getSummary() {
        return "Scorecard";
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, ?> predictions;
        Scorecard scorecard = (Scorecard)this.getModel();
        if (!scorecard.isScorable()) {
            throw new InvalidResultException(scorecard);
        }
        MiningFunctionType miningFunction = scorecard.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException(scorecard, miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ?> evaluateRegression(ModelEvaluationContext context) {
        Scorecard scorecard = (Scorecard)this.getModel();
        double value = 0.0;
        boolean useReasonCodes = scorecard.isUseReasonCodes();
        VoteCounter<String> reasonCodePoints = new VoteCounter<String>();
        Characteristics characteristics = scorecard.getCharacteristics();
        block4: for (Characteristic characteristic : characteristics) {
            Double baselineScore = characteristic.getBaselineScore();
            if (baselineScore == null) {
                baselineScore = scorecard.getBaselineScore();
            }
            if (useReasonCodes && baselineScore == null) {
                throw new InvalidFeatureException(characteristic);
            }
            List<Attribute> attributes = characteristic.getAttributes();
            for (Attribute attribute : attributes) {
                Double difference;
                org.dmg.pmml.Predicate predicate = attribute.getPredicate();
                if (predicate == null) {
                    throw new InvalidFeatureException(attribute);
                }
                Boolean status = PredicateUtil.evaluate(predicate, context);
                if (status == null || !status.booleanValue()) continue;
                Double partialScore = attribute.getPartialScore();
                if (partialScore == null) {
                    throw new InvalidFeatureException(attribute);
                }
                value += partialScore.doubleValue();
                String reasonCode = attribute.getReasonCode();
                if (reasonCode == null) {
                    reasonCode = characteristic.getReasonCode();
                }
                if (!useReasonCodes) continue block4;
                if (reasonCode == null) {
                    throw new InvalidFeatureException(attribute);
                }
                Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm = scorecard.getReasonCodeAlgorithm();
                switch (reasonCodeAlgorithm) {
                    case POINTS_ABOVE: {
                        difference = partialScore - baselineScore;
                        break;
                    }
                    case POINTS_BELOW: {
                        difference = baselineScore - partialScore;
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException(scorecard, reasonCodeAlgorithm);
                    }
                }
                reasonCodePoints.increment(reasonCode, difference);
                continue block4;
            }
        }
        Map<FieldName, ? extends Number> result = TargetUtil.evaluateRegression(value, context);
        if (useReasonCodes) {
            Map.Entry<FieldName, ? extends Number> resultEntry = Iterables.getOnlyElement(result.entrySet());
            return Collections.singletonMap(resultEntry.getKey(), ScorecardEvaluator.createScoreMap(resultEntry.getValue(), reasonCodePoints));
        }
        return result;
    }

    private static ScoreClassificationMap createScoreMap(Number value, Map<String, Double> reasonCodePoints) {
        ScoreClassificationMap result = new ScoreClassificationMap(value);
        Predicate<Map.Entry<String, Double>> predicate = new Predicate<Map.Entry<String, Double>>(){

            @Override
            public boolean apply(Map.Entry<String, Double> entry) {
                return Double.compare(entry.getValue(), 0.0) >= 0;
            }
        };
        result.putAll(Maps.filterEntries(reasonCodePoints, predicate));
        return result;
    }
}

