/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeatureType;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputUtil {
    private OutputUtil() {
    }

    public static <M extends Model> Map<FieldName, Object> evaluate(ModelManager<M> modelManager, Map<FieldName, ?> parameters, Map<FieldName, ?> predictions) {
        LinkedHashMap<FieldName, Object> result = new LinkedHashMap<FieldName, Object>();
        if (!Collections.disjoint(parameters.keySet(), predictions.keySet())) {
            throw new EvaluationException();
        }
        result.putAll(predictions);
        LinkedHashMap<FieldName, Object> globalParameters = new LinkedHashMap<FieldName, Object>();
        globalParameters.putAll(parameters);
        globalParameters.putAll(EvaluatorUtil.decodeValues(predictions));
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext(modelManager, globalParameters);
        Output output = modelManager.getOrCreateOutput();
        List<OutputField> outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            Object value;
            ResultFeatureType resultFeature = outputField.getFeature();
            switch (resultFeature) {
                case PREDICTED_VALUE: {
                    FieldName target = OutputUtil.getTarget(modelManager, outputField);
                    if (!predictions.containsKey(target)) {
                        throw new EvaluationException();
                    }
                    value = globalParameters.get(target);
                    break;
                }
                case TRANSFORMED_VALUE: {
                    Expression expression = outputField.getExpression();
                    if (expression == null) {
                        throw new EvaluationException();
                    }
                    value = ExpressionUtil.evaluate(expression, (EvaluationContext)context);
                    if (!(value instanceof Computable)) break;
                    throw new EvaluationException();
                }
                case PROBABILITY: {
                    FieldName target = OutputUtil.getTarget(modelManager, outputField);
                    if (!predictions.containsKey(target)) {
                        throw new EvaluationException();
                    }
                    value = OutputUtil.getProbability(result.get(target), outputField.getValue());
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException(resultFeature);
                }
            }
            DataType dataType = outputField.getDataType();
            if (dataType != null) {
                value = ParameterUtil.cast(dataType, value);
            }
            FieldName name = outputField.getName();
            result.put(name, value);
            globalParameters.put(name, value);
        }
        return result;
    }

    private static FieldName getTarget(ModelManager<?> modelManager, OutputField outputField) {
        FieldName result = outputField.getTargetField();
        if (result == null) {
            result = modelManager.getTarget();
        }
        return result;
    }

    private static Double getProbability(Object result, String value) {
        if (!(result instanceof Classification)) {
            throw new EvaluationException();
        }
        Classification classification = (Classification)result;
        return classification.getProbability(value);
    }
}

