/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.math.BigDecimal;
import java.util.List;
import org.dmg.pmml.ArrayType;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.False;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.MissingParameterException;
import org.jpmml.manager.UnsupportedFeatureException;

public class PredicateUtil {
    private PredicateUtil() {
    }

    public static Boolean evaluatePredicate(Predicate predicate, EvaluationContext context) {
        if (predicate instanceof SimplePredicate) {
            return PredicateUtil.evaluateSimplePredicate((SimplePredicate)predicate, context);
        }
        if (predicate instanceof CompoundPredicate) {
            return PredicateUtil.evaluateCompoundPredicate((CompoundPredicate)predicate, context);
        }
        if (predicate instanceof SimpleSetPredicate) {
            return PredicateUtil.evaluateSimpleSetPredicate((SimpleSetPredicate)predicate, context);
        }
        if (predicate instanceof True) {
            return PredicateUtil.evaluateTruePredicate((True)predicate);
        }
        if (predicate instanceof False) {
            return PredicateUtil.evaluateFalsePredicate((False)predicate);
        }
        throw new UnsupportedFeatureException(predicate);
    }

    public static Boolean evaluateSimplePredicate(SimplePredicate simplePredicate, EvaluationContext context) {
        Object value = ExpressionUtil.evaluate(simplePredicate.getField(), context);
        switch (simplePredicate.getOperator()) {
            case IS_MISSING: {
                return value == null;
            }
            case IS_NOT_MISSING: {
                return value != null;
            }
        }
        if (value == null) {
            return null;
        }
        String refValue = simplePredicate.getValue();
        SimplePredicate.Operator operator = simplePredicate.getOperator();
        switch (operator) {
            case EQUAL: {
                return PredicateUtil.compare(value, refValue) == 0;
            }
            case NOT_EQUAL: {
                return PredicateUtil.compare(value, refValue) != 0;
            }
            case LESS_THAN: {
                return PredicateUtil.compare(value, refValue) < 0;
            }
            case LESS_OR_EQUAL: {
                return PredicateUtil.compare(value, refValue) <= 0;
            }
            case GREATER_THAN: {
                return PredicateUtil.compare(value, refValue) > 0;
            }
            case GREATER_OR_EQUAL: {
                return PredicateUtil.compare(value, refValue) >= 0;
            }
        }
        throw new UnsupportedFeatureException(operator);
    }

    public static Boolean evaluateCompoundPredicate(CompoundPredicate compoundPredicate, EvaluationContext context) {
        List<Predicate> predicates = compoundPredicate.getContent();
        Boolean result = PredicateUtil.evaluatePredicate(predicates.get(0), context);
        switch (compoundPredicate.getBooleanOperator()) {
            case AND: 
            case OR: 
            case XOR: {
                break;
            }
            case SURROGATE: {
                if (result == null) break;
                return result;
            }
        }
        for (Predicate predicate : predicates.subList(1, predicates.size())) {
            Boolean value = PredicateUtil.evaluatePredicate(predicate, context);
            switch (compoundPredicate.getBooleanOperator()) {
                case AND: {
                    result = PredicateUtil.binaryAnd(result, value);
                    break;
                }
                case OR: {
                    result = PredicateUtil.binaryOr(result, value);
                    break;
                }
                case XOR: {
                    result = PredicateUtil.binaryXor(result, value);
                    break;
                }
                case SURROGATE: {
                    if (value == null) break;
                    return value;
                }
            }
        }
        return result;
    }

    public static Boolean evaluateSimpleSetPredicate(SimpleSetPredicate simpleSetPredicate, EvaluationContext context) {
        Object value = ExpressionUtil.evaluate(simpleSetPredicate.getField(), context);
        if (value == null) {
            throw new MissingParameterException(simpleSetPredicate.getField());
        }
        ArrayType array = simpleSetPredicate.getArray();
        SimpleSetPredicate.BooleanOperator operator = simpleSetPredicate.getBooleanOperator();
        switch (operator) {
            case IS_IN: {
                return ArrayUtil.isIn(array, value);
            }
            case IS_NOT_IN: {
                return ArrayUtil.isNotIn(array, value);
            }
        }
        throw new UnsupportedFeatureException(operator);
    }

    public static Boolean evaluateTruePredicate(True truePredicate) {
        return Boolean.TRUE;
    }

    public static Boolean evaluateFalsePredicate(False falsePredicate) {
        return Boolean.FALSE;
    }

    public static int compare(Object left, String right) {
        if (left instanceof Number) {
            return new BigDecimal(String.valueOf(left)).compareTo(new BigDecimal(right));
        }
        return String.valueOf(left).compareTo(right);
    }

    public static Boolean binaryAnd(Boolean left, Boolean right) {
        if (left == null) {
            if (right == null || right.booleanValue()) {
                return null;
            }
            return Boolean.FALSE;
        }
        if (right == null) {
            if (left == null || left.booleanValue()) {
                return null;
            }
            return Boolean.FALSE;
        }
        return left & right;
    }

    public static Boolean binaryOr(Boolean left, Boolean right) {
        if (left != null && left.booleanValue()) {
            return Boolean.TRUE;
        }
        if (right != null && right.booleanValue()) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return null;
        }
        return left | right;
    }

    public static Boolean binaryXor(Boolean left, Boolean right) {
        if (left == null || right == null) {
            return null;
        }
        return left ^ right;
    }
}

