/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import java.util.List;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Segment;
import org.dmg.pmml.Segmentation;
import org.dmg.pmml.TreeModel;
import org.dmg.pmml.True;
import org.jpmml.manager.SegmentationModelManager;

public class RandomForestManager
extends SegmentationModelManager {
    public RandomForestManager() {
    }

    public RandomForestManager(PMML pmml) {
        super(pmml);
    }

    public RandomForestManager(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
    }

    public String getSummary() {
        return "Random forest";
    }

    public Segment addSegment(TreeModel treeModel) {
        return this.addSegment(new True(), treeModel);
    }

    public Segment addSegment(Predicate predicate, TreeModel treeModel) {
        Segment segment = new Segment();
        segment.setPredicate(predicate);
        segment.setModel(treeModel);
        this.getSegments().add(segment);
        return segment;
    }

    public static boolean isRandomForest(MiningModel miningModel) {
        Segmentation segmentation = miningModel.getSegmentation();
        if (segmentation != null) {
            return RandomForestManager.isRandomForest(segmentation);
        }
        return false;
    }

    private static boolean isRandomForest(Segmentation segmentation) {
        boolean result = true;
        List<Segment> segments = segmentation.getSegments();
        for (Segment segment : segments) {
            result &= RandomForestManager.isTree(segment);
        }
        return result;
    }

    private static boolean isTree(Segment segment) {
        Model model = segment.getModel();
        return model instanceof TreeModel;
    }
}

