/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeatureType;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputUtil {
    private OutputUtil() {
    }

    public static Map<FieldName, Object> evaluate(Map<FieldName, ?> predictions, ModelManagerEvaluationContext context) {
        LinkedHashMap<FieldName, Object> result = new LinkedHashMap<FieldName, Object>(predictions);
        context = context.clone();
        ModelManager<?> modelManager = context.getModelManager();
        Output output = modelManager.getOrCreateOutput();
        List<OutputField> outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            Object value;
            ResultFeatureType resultFeature = outputField.getFeature();
            switch (resultFeature) {
                case PREDICTED_VALUE: {
                    FieldName target = OutputUtil.getTarget(modelManager, outputField);
                    if (!predictions.containsKey(target)) {
                        throw new EvaluationException();
                    }
                    value = EvaluatorUtil.decode(predictions.get(target));
                    break;
                }
                case TRANSFORMED_VALUE: {
                    Expression expression = outputField.getExpression();
                    if (expression == null) {
                        throw new EvaluationException();
                    }
                    value = ExpressionUtil.evaluate(expression, (EvaluationContext)context);
                    break;
                }
                case PROBABILITY: {
                    FieldName target = OutputUtil.getTarget(modelManager, outputField);
                    if (!predictions.containsKey(target)) {
                        throw new EvaluationException();
                    }
                    value = OutputUtil.getProbability(predictions.get(target), outputField.getValue());
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException(resultFeature);
                }
            }
            FieldName name = outputField.getName();
            DataType dataType = outputField.getDataType();
            if (dataType != null) {
                value = ParameterUtil.cast(dataType, value);
            }
            result.put(name, value);
            context.putParameter(name, value);
        }
        return result;
    }

    private static FieldName getTarget(ModelManager<?> modelManager, OutputField outputField) {
        FieldName result = outputField.getTargetField();
        if (result == null) {
            result = modelManager.getTarget();
        }
        return result;
    }

    private static Double getProbability(Object result, String value) {
        if (!(result instanceof Classification)) {
            throw new EvaluationException();
        }
        Classification classification = (Classification)result;
        return classification.getProbability(value);
    }
}

