/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.manager.UnsupportedFeatureException;

public class ParameterUtil {
    private static final DataType[] precedenceSequence = new DataType[]{DataType.STRING, DataType.DOUBLE, DataType.FLOAT, DataType.INTEGER};

    private ParameterUtil() {
    }

    public static Object prepare(DataField dataField, MiningField miningField, Object value) {
        if (dataField == null) {
            throw new EvaluationException();
        }
        if (ParameterUtil.isOutlier(dataField, value)) {
            if (miningField == null) {
                throw new EvaluationException();
            }
            OutlierTreatmentMethodType outlierTreatmentMethod = miningField.getOutlierTreatment();
            switch (outlierTreatmentMethod) {
                case AS_IS: {
                    break;
                }
                case AS_MISSING_VALUES: {
                    value = null;
                    break;
                }
                case AS_EXTREME_VALUES: {
                    Double lowValue = miningField.getLowValue();
                    Double highValue = miningField.getHighValue();
                    if (lowValue == null || highValue == null) {
                        throw new EvaluationException();
                    }
                    DataType dataType = dataField.getDataType();
                    if (ParameterUtil.compare(dataType, value, lowValue) < 0) {
                        value = lowValue;
                        break;
                    }
                    if (ParameterUtil.compare(dataType, value, highValue) <= 0) break;
                    value = highValue;
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException(outlierTreatmentMethod);
                }
            }
        }
        if (ParameterUtil.isMissing(dataField, value)) {
            if (miningField == null) {
                return null;
            }
            value = miningField.getMissingValueReplacement();
            if (value == null) {
                return null;
            }
        }
        if (ParameterUtil.isInvalid(dataField, value)) {
            if (miningField == null) {
                throw new EvaluationException();
            }
            InvalidValueTreatmentMethodType invalidValueTreatmentMethod = miningField.getInvalidValueTreatment();
            switch (invalidValueTreatmentMethod) {
                case RETURN_INVALID: {
                    throw new EvaluationException();
                }
                case AS_IS: {
                    break;
                }
                case AS_MISSING: {
                    value = miningField.getMissingValueReplacement();
                    if (value != null) break;
                    return null;
                }
                default: {
                    throw new UnsupportedFeatureException(invalidValueTreatmentMethod);
                }
            }
        }
        return ParameterUtil.cast(dataField.getDataType(), value);
    }

    private static boolean isOutlier(DataField dataField, Object value) {
        if (value == null) {
            return false;
        }
        OpType opType = dataField.getOptype();
        switch (opType) {
            case CONTINUOUS: {
                Double minValue;
                ArrayList<Double> range = new ArrayList<Double>();
                List<Interval> fieldIntervals = dataField.getIntervals();
                for (Interval fieldInterval : fieldIntervals) {
                    range.add(fieldInterval.getLeftMargin());
                    range.add(fieldInterval.getRightMargin());
                }
                List<Value> fieldValues = dataField.getValues();
                for (Value fieldValue : fieldValues) {
                    Value.Property property = fieldValue.getProperty();
                    switch (property) {
                        case VALID: {
                            range.add(ParameterUtil.toDouble(fieldValue.getValue()));
                            break;
                        }
                    }
                }
                if (range.isEmpty()) {
                    return false;
                }
                Double doubleValue = ParameterUtil.toDouble(value);
                if (doubleValue.compareTo(minValue = (Double)Collections.min(range)) < 0) {
                    return true;
                }
                Double maxValue = (Double)Collections.max(range);
                if (doubleValue.compareTo(maxValue) <= 0) break;
                return true;
            }
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException(opType);
            }
        }
        return false;
    }

    private static boolean isMissing(DataField dataField, Object value) {
        if (value == null) {
            return true;
        }
        List<Value> fieldValues = dataField.getValues();
        block3: for (Value fieldValue : fieldValues) {
            Value.Property property = fieldValue.getProperty();
            switch (property) {
                case MISSING: {
                    boolean equals = ParameterUtil.equals(DataType.STRING, value, fieldValue.getValue());
                    if (!equals) continue block3;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isInvalid(DataField dataField, Object value) {
        return !ParameterUtil.isValid(dataField, value);
    }

    private static boolean isValid(DataField dataField, Object value) {
        DataType dataType = dataField.getDataType();
        value = ParameterUtil.cast(dataType, value);
        OpType opType = dataField.getOptype();
        switch (opType) {
            case CONTINUOUS: {
                Double doubleValue = ParameterUtil.toDouble(value);
                int intervalCount = 0;
                List<Interval> fieldIntervals = dataField.getIntervals();
                for (Interval fieldInterval : fieldIntervals) {
                    ++intervalCount;
                    if (!DiscretizationUtil.contains(fieldInterval, doubleValue)) continue;
                    return true;
                }
                if (intervalCount > 0) {
                    return false;
                }
            }
            case CATEGORICAL: 
            case ORDINAL: {
                int validValueCount = 0;
                List<Value> fieldValues = dataField.getValues();
                block10: for (Value fieldValue : fieldValues) {
                    Value.Property property = fieldValue.getProperty();
                    switch (property) {
                        case VALID: {
                            ++validValueCount;
                            boolean equals = ParameterUtil.equals(dataType, value, fieldValue.getValue());
                            if (!equals) continue block10;
                            return true;
                        }
                        case INVALID: {
                            boolean equals = ParameterUtil.equals(dataType, value, fieldValue.getValue());
                            if (!equals) continue block10;
                            return false;
                        }
                        case MISSING: {
                            break;
                        }
                        default: {
                            throw new UnsupportedFeatureException(property);
                        }
                    }
                }
                return validValueCount <= 0;
            }
            default: {
                throw new UnsupportedFeatureException(opType);
            }
        }
    }

    public static boolean equals(Object value, String string) {
        return ParameterUtil.equals(ParameterUtil.getDataType(value), value, string);
    }

    private static boolean equals(DataType dataType, Object left, Object right) {
        return ParameterUtil.cast(dataType, left).equals(ParameterUtil.cast(dataType, right));
    }

    private static int compare(DataType dataType, Object left, Object right) {
        return ((Comparable)ParameterUtil.cast(dataType, left)).compareTo((Comparable)ParameterUtil.cast(dataType, right));
    }

    public static Object parse(DataType dataType, String string) {
        switch (dataType) {
            case STRING: {
                return string;
            }
            case INTEGER: {
                return new Integer(string);
            }
            case FLOAT: {
                return new Float(string);
            }
            case DOUBLE: {
                return new Double(string);
            }
        }
        throw new UnsupportedFeatureException(dataType);
    }

    public static DataType getDataType(Object value) {
        if (value instanceof String) {
            return DataType.STRING;
        }
        if (value instanceof Integer) {
            return DataType.INTEGER;
        }
        if (value instanceof Float) {
            return DataType.FLOAT;
        }
        if (value instanceof Double) {
            return DataType.DOUBLE;
        }
        throw new EvaluationException();
    }

    public static DataType getResultDataType(Object left, Object right) {
        return ParameterUtil.getResultDataType(ParameterUtil.getDataType(left), ParameterUtil.getDataType(right));
    }

    public static DataType getResultDataType(DataType left, DataType right) {
        DataType[] dataTypes;
        if (left.equals((Object)right)) {
            return left;
        }
        for (DataType dataType : dataTypes = precedenceSequence) {
            if (!dataType.equals((Object)left) && !dataType.equals((Object)right)) continue;
            return dataType;
        }
        throw new EvaluationException();
    }

    public static Object cast(DataType dataType, Object value) {
        switch (dataType) {
            case STRING: {
                return ParameterUtil.toString(value);
            }
            case INTEGER: {
                return ParameterUtil.toInteger(value);
            }
            case FLOAT: {
                return ParameterUtil.toFloat(value);
            }
            case DOUBLE: {
                return ParameterUtil.toDouble(value);
            }
        }
        throw new EvaluationException();
    }

    public static String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.toString();
        }
        throw new EvaluationException();
    }

    public static Integer toInteger(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return Integer.valueOf(string);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        throw new EvaluationException();
    }

    public static Float toFloat(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return Float.valueOf(string);
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        throw new EvaluationException();
    }

    public static Double toDouble(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return Double.valueOf(string);
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        throw new EvaluationException();
    }

    public static DataType getConstantDataType(String string) {
        try {
            if (string.indexOf(46) > -1) {
                Float.parseFloat(string);
                return DataType.FLOAT;
            }
            Integer.parseInt(string);
            return DataType.INTEGER;
        }
        catch (NumberFormatException nfe) {
            return DataType.STRING;
        }
    }
}

