/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import org.dmg.pmml.MiningModel;
import org.dmg.pmml.Model;
import org.dmg.pmml.NeuralNetwork;
import org.dmg.pmml.PMML;
import org.dmg.pmml.RegressionModel;
import org.dmg.pmml.TreeModel;
import org.jpmml.manager.MiningModelManager;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.NeuralNetworkManager;
import org.jpmml.manager.RegressionModelManager;
import org.jpmml.manager.TreeModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelManagerFactory {
    protected ModelManagerFactory() {
    }

    public ModelManager<? extends Model> getModelManager(PMML pmml, Model model) {
        if (model instanceof RegressionModel) {
            return new RegressionModelManager(pmml, (RegressionModel)model);
        }
        if (model instanceof TreeModel) {
            return new TreeModelManager(pmml, (TreeModel)model);
        }
        if (model instanceof NeuralNetwork) {
            return new NeuralNetworkManager(pmml, (NeuralNetwork)model);
        }
        if (model instanceof MiningModel) {
            return new MiningModelManager(pmml, (MiningModel)model);
        }
        throw new UnsupportedFeatureException(model);
    }

    public static ModelManagerFactory getInstance() {
        return new ModelManagerFactory();
    }
}

