/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import java.util.List;
import org.dmg.pmml.CategoricalPredictor;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.NumericPredictor;
import org.dmg.pmml.PMML;
import org.dmg.pmml.RegressionModel;
import org.dmg.pmml.RegressionTable;
import org.jpmml.manager.ModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionModelManager
extends ModelManager<RegressionModel> {
    private RegressionModel regressionModel = null;

    public RegressionModelManager() {
    }

    public RegressionModelManager(PMML pmml) {
        this(pmml, RegressionModelManager.find(pmml.getContent(), RegressionModel.class));
    }

    public RegressionModelManager(PMML pmml, RegressionModel regressionModel) {
        super(pmml);
        this.regressionModel = regressionModel;
    }

    @Override
    public String getSummary() {
        return "Regression";
    }

    @Override
    public RegressionModel getModel() {
        RegressionModelManager.ensureNotNull(this.regressionModel);
        return this.regressionModel;
    }

    public RegressionModel createRegressionModel() {
        return this.createModel(MiningFunctionType.REGRESSION);
    }

    public RegressionModel createModel(MiningFunctionType miningFunction) {
        RegressionModelManager.ensureNull(this.regressionModel);
        this.regressionModel = new RegressionModel(new MiningSchema(), miningFunction);
        this.getModels().add(this.regressionModel);
        return this.regressionModel;
    }

    @Override
    public FieldName getTarget() {
        RegressionModel regressionModel = this.getModel();
        FieldName name = regressionModel.getTargetFieldName();
        if (name != null) {
            return name;
        }
        return super.getTarget();
    }

    public RegressionModel setTarget(FieldName name) {
        RegressionModel regressionModel = this.getModel();
        regressionModel.setTargetFieldName(name);
        return regressionModel;
    }

    public List<RegressionTable> getRegressionTables() {
        RegressionModel model = this.getModel();
        return model.getRegressionTables();
    }

    public static NumericPredictor getNumericPredictor(RegressionTable regressionTable, FieldName name) {
        return RegressionModelManager.find(regressionTable.getNumericPredictors(), name);
    }

    public static NumericPredictor addNumericPredictor(RegressionTable regressionTable, FieldName name, Double coefficient) {
        NumericPredictor numericPredictor = new NumericPredictor(name, coefficient);
        regressionTable.getNumericPredictors().add(numericPredictor);
        return numericPredictor;
    }

    public static CategoricalPredictor getCategoricalPredictor(RegressionTable regressionTable, FieldName name) {
        return RegressionModelManager.find(regressionTable.getCategoricalPredictors(), name);
    }

    public static CategoricalPredictor addCategoricalPredictor(RegressionTable regressionTable, FieldName name, String value, Double coefficient) {
        CategoricalPredictor categoricalPredictor = new CategoricalPredictor(name, value, coefficient);
        regressionTable.getCategoricalPredictors().add(categoricalPredictor);
        return categoricalPredictor;
    }
}

