/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.Model;
import org.dmg.pmml.MultipleModelMethodType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Segment;
import org.dmg.pmml.Segmentation;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.manager.MiningModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiningModelEvaluator
extends MiningModelManager
implements Evaluator {
    private static final ModelEvaluatorFactory evaluatorFactory = ModelEvaluatorFactory.getInstance();

    public MiningModelEvaluator(PMML pmml) {
        super(pmml);
    }

    public MiningModelEvaluator(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
    }

    public MiningModelEvaluator(MiningModelManager parent) {
        this(parent.getPmml(), parent.getModel());
    }

    @Override
    public Object prepare(FieldName name, Object value) {
        return ParameterUtil.prepare(this.getDataField(name), this.getMiningField(name), value);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> parameters) {
        Map<FieldName, ?> predictions;
        MiningModel model = this.getModel();
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext(this, parameters);
        MiningFunctionType miningFunction = model.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException(miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    public Map<FieldName, ?> evaluateRegression(EvaluationContext context) {
        Double result;
        List<SegmentResult> segmentResults = this.evaluate(context);
        Segmentation segmentation = this.getSegmentation();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_FIRST: 
            case MODEL_CHAIN: {
                return this.dispatchSingleResult(segmentResults);
            }
            case SELECT_ALL: {
                throw new UnsupportedFeatureException(multipleModelMethod);
            }
        }
        double sum = 0.0;
        double weightedSum = 0.0;
        for (SegmentResult segmentResult : segmentResults) {
            Object predictedValue = EvaluatorUtil.decode(segmentResult.getPrediction());
            Double value = ParameterUtil.toDouble(predictedValue);
            sum += value.doubleValue();
            weightedSum += segmentResult.getSegment().getWeight() * value;
        }
        int count = segmentResults.size();
        switch (multipleModelMethod) {
            case SUM: {
                result = sum;
                break;
            }
            case AVERAGE: {
                result = sum / (double)count;
                break;
            }
            case WEIGHTED_AVERAGE: {
                result = weightedSum / (double)count;
                break;
            }
            default: {
                throw new UnsupportedFeatureException(multipleModelMethod);
            }
        }
        return Collections.singletonMap(this.getTarget(), result);
    }

    public Map<FieldName, ?> evaluateClassification(EvaluationContext context) {
        List<SegmentResult> segmentResults = this.evaluate(context);
        Segmentation segmentation = this.getSegmentation();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_FIRST: 
            case MODEL_CHAIN: {
                return this.dispatchSingleResult(segmentResults);
            }
            case SELECT_ALL: {
                throw new UnsupportedFeatureException(multipleModelMethod);
            }
        }
        ClassificationMap result = new ClassificationMap();
        for (SegmentResult segmentResult : segmentResults) {
            Object predictedValue = EvaluatorUtil.decode(segmentResult.getPrediction());
            String value = ParameterUtil.toString(predictedValue);
            Double vote = (Double)result.get(value);
            if (vote == null) {
                vote = 0.0;
            }
            switch (multipleModelMethod) {
                case MAJORITY_VOTE: {
                    vote = vote + 1.0;
                    break;
                }
                case WEIGHTED_MAJORITY_VOTE: {
                    vote = vote + segmentResult.getSegment().getWeight() * 1.0;
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException(multipleModelMethod);
                }
            }
            result.put(value, vote);
        }
        result.normalizeProbabilities();
        return Collections.singletonMap(this.getTarget(), result);
    }

    private Map<FieldName, ?> dispatchSingleResult(List<SegmentResult> results) {
        if (results.size() < 1 || results.size() > 1) {
            throw new EvaluationException();
        }
        SegmentResult result = results.get(0);
        return result.getResult();
    }

    private List<SegmentResult> evaluate(EvaluationContext context) {
        ArrayList<SegmentResult> results = new ArrayList<SegmentResult>();
        Segmentation segmentation = this.getSegmentation();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        List<Segment> segments = segmentation.getSegments();
        for (Segment segment : segments) {
            Predicate predicate = segment.getPredicate();
            Boolean selectable = PredicateUtil.evaluate(predicate, context);
            if (selectable == null) {
                throw new EvaluationException();
            }
            if (!selectable.booleanValue()) continue;
            Model model = segment.getModel();
            Evaluator evaluator = (Evaluator)((Object)evaluatorFactory.getModelManager(this.getPmml(), model));
            FieldName target = evaluator.getTarget();
            Map<FieldName, ?> result = evaluator.evaluate(context.getParameters());
            switch (multipleModelMethod) {
                case SELECT_FIRST: {
                    return Collections.singletonList(new SegmentResult(segment, target, result));
                }
                case MODEL_CHAIN: {
                    List<FieldName> outputFields = evaluator.getOutputFields();
                    for (FieldName outputField : outputFields) {
                        Object outputValue = result.get(outputField);
                        if (outputValue == null) {
                            throw new EvaluationException();
                        }
                        outputValue = EvaluatorUtil.decode(outputValue);
                        context.putParameter(outputField, outputValue);
                    }
                    results.clear();
                }
            }
            results.add(new SegmentResult(segment, target, result));
        }
        return results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SegmentResult {
        private Segment segment = null;
        private FieldName predictedField = null;
        private Map<FieldName, ?> result = null;

        public SegmentResult(Segment segment, FieldName predictedField, Map<FieldName, ?> result) {
            this.setSegment(segment);
            this.setPredictedField(predictedField);
            this.setResult(result);
        }

        public Object getPrediction() {
            return this.getResult().get(this.getPredictedField());
        }

        public Segment getSegment() {
            return this.segment;
        }

        private void setSegment(Segment segment) {
            this.segment = segment;
        }

        public FieldName getPredictedField() {
            return this.predictedField;
        }

        private void setPredictedField(FieldName predictedField) {
            this.predictedField = predictedField;
        }

        public Map<FieldName, ?> getResult() {
            return this.result;
        }

        private void setResult(Map<FieldName, ?> result) {
            this.result = result;
        }
    }
}

