/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.MiningModel;
import org.dmg.pmml.Model;
import org.dmg.pmml.NeuralNetwork;
import org.dmg.pmml.PMML;
import org.dmg.pmml.RegressionModel;
import org.dmg.pmml.TreeModel;
import org.jpmml.evaluator.MiningModelEvaluator;
import org.jpmml.evaluator.NeuralNetworkEvaluator;
import org.jpmml.evaluator.RegressionModelEvaluator;
import org.jpmml.evaluator.TreeModelEvaluator;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.ModelManagerFactory;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEvaluatorFactory
extends ModelManagerFactory {
    protected ModelEvaluatorFactory() {
    }

    @Override
    public ModelManager<? extends Model> getModelManager(PMML pmml, Model model) {
        if (model instanceof RegressionModel) {
            return new RegressionModelEvaluator(pmml, (RegressionModel)model);
        }
        if (model instanceof TreeModel) {
            return new TreeModelEvaluator(pmml, (TreeModel)model);
        }
        if (model instanceof NeuralNetwork) {
            return new NeuralNetworkEvaluator(pmml, (NeuralNetwork)model);
        }
        if (model instanceof MiningModel) {
            return new MiningModelEvaluator(pmml, (MiningModel)model);
        }
        throw new UnsupportedFeatureException(model);
    }

    public static ModelEvaluatorFactory getInstance() {
        return new ModelEvaluatorFactory();
    }
}

