/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.ActivationFunctionType;
import org.dmg.pmml.Connection;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.NeuralInput;
import org.dmg.pmml.NeuralLayer;
import org.dmg.pmml.NeuralNetwork;
import org.dmg.pmml.NeuralOutput;
import org.dmg.pmml.Neuron;
import org.dmg.pmml.NnNormalizationMethodType;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.MissingParameterException;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.NormalizationUtil;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.manager.NeuralNetworkManager;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeuralNetworkEvaluator
extends NeuralNetworkManager
implements Evaluator {
    public NeuralNetworkEvaluator(PMML pmml) {
        super(pmml);
    }

    public NeuralNetworkEvaluator(PMML pmml, NeuralNetwork neuralNetwork) {
        super(pmml, neuralNetwork);
    }

    public NeuralNetworkEvaluator(NeuralNetworkManager parent) {
        this(parent.getPmml(), parent.getModel());
    }

    @Override
    public Object prepare(FieldName name, Object value) {
        return ParameterUtil.prepare(this.getDataField(name), this.getMiningField(name), value);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> parameters) {
        Map<FieldName, Serializable> predictions;
        NeuralNetwork neuralNetwork = this.getModel();
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext(this, parameters);
        MiningFunctionType miningFunction = neuralNetwork.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException(miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    public Map<FieldName, Double> evaluateRegression(EvaluationContext context) {
        LinkedHashMap<FieldName, Double> result = new LinkedHashMap<FieldName, Double>();
        Map<String, Double> neuronOutputs = this.evaluateRaw(context);
        List<NeuralOutput> neuralOutputs = this.getOrCreateNeuralOutputs();
        for (NeuralOutput neuralOutput : neuralOutputs) {
            FieldName field;
            String id = neuralOutput.getOutputNeuron();
            Expression expression = this.getExpression(neuralOutput.getDerivedField());
            if (expression instanceof FieldRef) {
                FieldRef fieldRef = (FieldRef)expression;
                field = fieldRef.getField();
                result.put(field, neuronOutputs.get(id));
                continue;
            }
            if (expression instanceof NormContinuous) {
                NormContinuous normContinuous = (NormContinuous)expression;
                field = normContinuous.getField();
                Double value = NormalizationUtil.denormalize(normContinuous, neuronOutputs.get(id));
                result.put(field, value);
                continue;
            }
            throw new UnsupportedFeatureException(expression);
        }
        return result;
    }

    public Map<FieldName, ClassificationMap> evaluateClassification(EvaluationContext context) {
        LinkedHashMap<FieldName, ClassificationMap> result = new LinkedHashMap<FieldName, ClassificationMap>();
        Map<String, Double> neuronOutputs = this.evaluateRaw(context);
        List<NeuralOutput> neuralOutputs = this.getOrCreateNeuralOutputs();
        for (NeuralOutput neuralOutput : neuralOutputs) {
            String id = neuralOutput.getOutputNeuron();
            Expression expression = this.getExpression(neuralOutput.getDerivedField());
            if (expression instanceof NormDiscrete) {
                NormDiscrete normDiscrete = (NormDiscrete)expression;
                FieldName field = normDiscrete.getField();
                ClassificationMap values = (ClassificationMap)result.get(field);
                if (values == null) {
                    values = new ClassificationMap();
                    result.put(field, values);
                }
                Double value = neuronOutputs.get(id);
                values.put(normDiscrete.getValue(), value);
                continue;
            }
            throw new UnsupportedFeatureException(expression);
        }
        return result;
    }

    private Expression getExpression(DerivedField derivedField) {
        Expression expression = derivedField.getExpression();
        if (expression instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)expression;
            derivedField = this.resolve(fieldRef.getField());
            if (derivedField != null) {
                return this.getExpression(derivedField);
            }
            return fieldRef;
        }
        return expression;
    }

    public Map<String, Double> evaluateRaw(EvaluationContext context) {
        LinkedHashMap<String, Double> result = new LinkedHashMap<String, Double>();
        List<NeuralInput> neuralInputs = this.getNeuralInputs();
        for (NeuralInput neuralInput : neuralInputs) {
            Double value = (Double)ExpressionUtil.evaluate(neuralInput.getDerivedField(), context);
            if (value == null) {
                throw new MissingParameterException(neuralInput.getDerivedField());
            }
            result.put(neuralInput.getId(), value);
        }
        List<NeuralLayer> neuralLayers = this.getNeuralLayers();
        for (NeuralLayer neuralLayer : neuralLayers) {
            List<Neuron> neurons = neuralLayer.getNeurons();
            for (Neuron neuron : neurons) {
                double z = neuron.getBias();
                List<Connection> connections = neuron.getConnections();
                for (Connection connection : connections) {
                    double input = (Double)result.get(connection.getFrom());
                    z += input * connection.getWeight();
                }
                double output = this.activation(z, neuralLayer);
                result.put(neuron.getId(), output);
            }
            this.normalizeNeuronOutputs(neuralLayer, result);
        }
        return result;
    }

    private void normalizeNeuronOutputs(NeuralLayer neuralLayer, Map<String, Double> neuronOutputs) {
        NeuralNetwork model = this.getModel();
        NnNormalizationMethodType normalizationMethod = neuralLayer.getNormalizationMethod();
        if (normalizationMethod == null) {
            normalizationMethod = model.getNormalizationMethod();
        }
        if (normalizationMethod == NnNormalizationMethodType.NONE) {
            return;
        }
        if (normalizationMethod == NnNormalizationMethodType.SOFTMAX) {
            double output;
            List<Neuron> neurons = neuralLayer.getNeurons();
            double sum = 0.0;
            for (Neuron neuron : neurons) {
                output = neuronOutputs.get(neuron.getId());
                sum += Math.exp(output);
            }
            for (Neuron neuron : neurons) {
                output = neuronOutputs.get(neuron.getId());
                neuronOutputs.put(neuron.getId(), Math.exp(output) / sum);
            }
        } else {
            throw new UnsupportedFeatureException(normalizationMethod);
        }
    }

    private double activation(double z, NeuralLayer layer) {
        NeuralNetwork model = this.getModel();
        ActivationFunctionType activationFunction = layer.getActivationFunction();
        if (activationFunction == null) {
            activationFunction = model.getActivationFunction();
        }
        switch (activationFunction) {
            case THRESHOLD: {
                Double threshold = layer.getThreshold();
                if (threshold == null) {
                    threshold = model.getThreshold();
                }
                return z > threshold ? 1.0 : 0.0;
            }
            case LOGISTIC: {
                return 1.0 / (1.0 + Math.exp(-z));
            }
            case TANH: {
                return (1.0 - Math.exp(-2.0 * z)) / (1.0 + Math.exp(-2.0 * z));
            }
            case IDENTITY: {
                return z;
            }
            case EXPONENTIAL: {
                return Math.exp(z);
            }
            case RECIPROCAL: {
                return 1.0 / z;
            }
            case SQUARE: {
                return z * z;
            }
            case GAUSS: {
                return Math.exp(-(z * z));
            }
            case SINE: {
                return Math.sin(z);
            }
            case COSINE: {
                return Math.cos(z);
            }
            case ELLIOTT: {
                return z / (1.0 + Math.abs(z));
            }
            case ARCTAN: {
                return Math.atan(z);
            }
        }
        throw new UnsupportedFeatureException(activationFunction);
    }
}

