/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.jpmml.evaluator.EvaluationException;

public class NormalizationUtil {
    public static double normalize(NormContinuous normContinuous, double value) {
        List<LinearNorm> linearNorms = normContinuous.getLinearNorms();
        LinearNorm rangeStart = linearNorms.get(0);
        LinearNorm rangeEnd = linearNorms.get(linearNorms.size() - 1);
        if (value >= rangeStart.getOrig() && value <= rangeEnd.getOrig()) {
            for (int i = 1; i < linearNorms.size() - 1; ++i) {
                LinearNorm linearNorm = linearNorms.get(i);
                if (value >= linearNorm.getOrig()) {
                    rangeStart = linearNorm;
                    continue;
                }
                if (!(value <= linearNorm.getOrig())) continue;
                rangeEnd = linearNorm;
                break;
            }
        } else {
            OutlierTreatmentMethodType outlierTreatmentMethod = normContinuous.getOutliers();
            switch (outlierTreatmentMethod) {
                case AS_MISSING_VALUES: {
                    Double missing = normContinuous.getMapMissingTo();
                    if (missing == null) {
                        throw new EvaluationException();
                    }
                    return missing;
                }
                case AS_IS: {
                    if (value < rangeStart.getOrig()) {
                        rangeEnd = linearNorms.get(1);
                        break;
                    }
                    rangeStart = linearNorms.get(linearNorms.size() - 2);
                    break;
                }
                case AS_EXTREME_VALUES: {
                    return value < rangeStart.getOrig() ? rangeStart.getNorm() : rangeEnd.getNorm();
                }
            }
        }
        double origRange = rangeEnd.getOrig() - rangeStart.getOrig();
        double normRange = rangeEnd.getNorm() - rangeStart.getNorm();
        return rangeStart.getNorm() + (value - rangeStart.getOrig()) / origRange * normRange;
    }

    public static double denormalize(NormContinuous normContinuous, double value) {
        List<LinearNorm> linearNorms = normContinuous.getLinearNorms();
        LinearNorm rangeStart = linearNorms.get(0);
        LinearNorm rangeEnd = linearNorms.get(linearNorms.size() - 1);
        for (int i = 1; i < linearNorms.size() - 1; ++i) {
            LinearNorm linearNorm = linearNorms.get(i);
            if (value >= linearNorm.getNorm()) {
                rangeStart = linearNorm;
                continue;
            }
            if (!(value <= linearNorm.getNorm())) continue;
            rangeEnd = linearNorm;
            break;
        }
        double origRange = rangeEnd.getOrig() - rangeStart.getOrig();
        double normRange = rangeEnd.getNorm() - rangeStart.getNorm();
        return (value - rangeStart.getNorm()) / normRange * origRange + rangeStart.getOrig();
    }
}

