/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.MissingResultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassificationMap
extends LinkedHashMap<String, Double>
implements Computable<String>,
HasProbability {
    ClassificationMap() {
    }

    @Override
    public String getResult() {
        Map.Entry result = null;
        Set entries = this.entrySet();
        for (Map.Entry entry : entries) {
            if (result != null && ((Double)entry.getValue()).compareTo((Double)result.getValue()) <= 0) continue;
            result = entry;
        }
        if (result == null) {
            throw new MissingResultException(null);
        }
        return (String)result.getKey();
    }

    @Override
    public Double getProbability(String value) {
        Double result = (Double)this.get(value);
        if (result == null) {
            result = 0.0;
        }
        return result;
    }

    void normalizeProbabilities() {
        double sum = 0.0;
        Collection values = this.values();
        for (Double value : values) {
            sum += value.doubleValue();
        }
        Set entries = this.entrySet();
        for (Map.Entry entry : entries) {
            entry.setValue((Double)entry.getValue() / sum);
        }
    }
}

