/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Product;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MissingResultException;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionUtil {
    private static final Map<String, Function> functions = new LinkedHashMap<String, Function>();

    private FunctionUtil() {
    }

    public static Object evaluate(Apply apply, List<?> values) {
        Function function = FunctionUtil.getFunction(apply.getFunction());
        if (function == null) {
            throw new UnsupportedFeatureException(apply);
        }
        return function.evaluate(values);
    }

    public static Function getFunction(String name) {
        return functions.get(name);
    }

    public static void putFunction(String name, Function function) {
        functions.put(name, function);
    }

    private static Boolean asBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new EvaluationException();
    }

    private static Number asNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new EvaluationException();
    }

    private static Integer asInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new EvaluationException();
    }

    private static String asString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new EvaluationException();
    }

    private static DataType integerToDouble(DataType dataType) {
        if (DataType.INTEGER.equals((Object)dataType)) {
            return DataType.DOUBLE;
        }
        return dataType;
    }

    static {
        FunctionUtil.putFunction("+", new ArithmeticFunction(){

            public Double evaluate(Number left, Number right) {
                return left.doubleValue() + right.doubleValue();
            }
        });
        FunctionUtil.putFunction("-", new ArithmeticFunction(){

            public Double evaluate(Number left, Number right) {
                return left.doubleValue() - right.doubleValue();
            }
        });
        FunctionUtil.putFunction("*", new ArithmeticFunction(){

            public Double evaluate(Number left, Number right) {
                return left.doubleValue() * right.doubleValue();
            }
        });
        FunctionUtil.putFunction("/", new ArithmeticFunction(){

            public Number evaluate(Number left, Number right) {
                if (left instanceof Integer && right instanceof Integer) {
                    return left.intValue() / right.intValue();
                }
                return left.doubleValue() / right.doubleValue();
            }
        });
        FunctionUtil.putFunction("min", new AggregateFunction(){

            public Min createStatistic() {
                return new Min();
            }
        });
        FunctionUtil.putFunction("max", new AggregateFunction(){

            public Max createStatistic() {
                return new Max();
            }
        });
        FunctionUtil.putFunction("avg", new AggregateFunction(){

            public Mean createStatistic() {
                return new Mean();
            }

            public Number cast(DataType dataType, Double result) {
                return super.cast(FunctionUtil.integerToDouble(dataType), result);
            }
        });
        FunctionUtil.putFunction("sum", new AggregateFunction(){

            public Sum createStatistic() {
                return new Sum();
            }
        });
        FunctionUtil.putFunction("product", new AggregateFunction(){

            public Product createStatistic() {
                return new Product();
            }
        });
        FunctionUtil.putFunction("log10", new FpMathFunction(){

            public Double evaluate(Number value) {
                return Math.log10(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("ln", new FpMathFunction(){

            public Double evaluate(Number value) {
                return Math.log(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("exp", new FpMathFunction(){

            public Double evaluate(Number value) {
                return Math.exp(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("sqrt", new FpMathFunction(){

            public Double evaluate(Number value) {
                return Math.sqrt(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("abs", new MathFunction(){

            public Double evaluate(Number value) {
                return Math.abs(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("pow", new Function(){

            @Override
            public Number evaluate(List<?> values) {
                if (values.size() != 2) {
                    throw new EvaluationException();
                }
                Number left = FunctionUtil.asNumber(values.get(0));
                Number right = FunctionUtil.asNumber(values.get(1));
                DataType dataType = ParameterUtil.getResultDataType(left, right);
                Double result = Math.pow(left.doubleValue(), right.doubleValue());
                return FunctionUtil.asNumber(ParameterUtil.cast(dataType, result));
            }
        });
        FunctionUtil.putFunction("threshold", new Function(){

            @Override
            public Number evaluate(List<?> values) {
                if (values.size() != 2) {
                    throw new EvaluationException();
                }
                Number left = FunctionUtil.asNumber(values.get(0));
                Number right = FunctionUtil.asNumber(values.get(1));
                DataType dataType = ParameterUtil.getResultDataType(left, right);
                Integer result = left.doubleValue() > right.doubleValue() ? 1 : 0;
                return FunctionUtil.asNumber(ParameterUtil.cast(dataType, result));
            }
        });
        FunctionUtil.putFunction("floor", new MathFunction(){

            public Double evaluate(Number number) {
                return Math.floor(number.doubleValue());
            }
        });
        FunctionUtil.putFunction("ceil", new MathFunction(){

            public Double evaluate(Number number) {
                return Math.ceil(number.doubleValue());
            }
        });
        FunctionUtil.putFunction("round", new MathFunction(){

            public Double evaluate(Number number) {
                return Math.round(number.doubleValue());
            }
        });
        FunctionUtil.putFunction("isMissing", new ValueFunction(){

            public Boolean evaluate(Object value) {
                return value == null;
            }
        });
        FunctionUtil.putFunction("isNotMissing", new ValueFunction(){

            public Boolean evaluate(Object value) {
                return value != null;
            }
        });
        FunctionUtil.putFunction("equal", new ComparisonFunction(){

            public Boolean evaluate(int diff) {
                return diff == 0;
            }
        });
        FunctionUtil.putFunction("notEqual", new ComparisonFunction(){

            public Boolean evaluate(int diff) {
                return diff != 0;
            }
        });
        FunctionUtil.putFunction("lessThan", new ComparisonFunction(){

            public Boolean evaluate(int diff) {
                return diff < 0;
            }
        });
        FunctionUtil.putFunction("lessOrEqual", new ComparisonFunction(){

            public Boolean evaluate(int diff) {
                return diff <= 0;
            }
        });
        FunctionUtil.putFunction("greaterThan", new ComparisonFunction(){

            public Boolean evaluate(int diff) {
                return diff > 0;
            }
        });
        FunctionUtil.putFunction("greaterOrEqual", new ComparisonFunction(){

            public Boolean evaluate(int diff) {
                return diff >= 0;
            }
        });
        FunctionUtil.putFunction("and", new BinaryBooleanFunction(){

            public Boolean evaluate(Boolean left, Boolean right) {
                return left & right;
            }
        });
        FunctionUtil.putFunction("or", new BinaryBooleanFunction(){

            public Boolean evaluate(Boolean left, Boolean right) {
                return left | right;
            }
        });
        FunctionUtil.putFunction("not", new UnaryBooleanFunction(){

            public Boolean evaluate(Boolean value) {
                return value == false;
            }
        });
        FunctionUtil.putFunction("isIn", new ValueListFunction(){

            @Override
            public Boolean evaluate(Object value, List<?> values) {
                return values.contains(value);
            }
        });
        FunctionUtil.putFunction("isNotIn", new ValueListFunction(){

            @Override
            public Boolean evaluate(Object value, List<?> values) {
                return !values.contains(value);
            }
        });
        FunctionUtil.putFunction("if", new Function(){

            @Override
            public Object evaluate(List<?> values) {
                if (values.size() < 2 || values.size() > 3) {
                    throw new EvaluationException();
                }
                Boolean flag = FunctionUtil.asBoolean(values.get(0));
                if (flag.booleanValue()) {
                    return values.get(1);
                }
                if (values.size() > 2) {
                    return values.get(2);
                }
                return null;
            }
        });
        FunctionUtil.putFunction("uppercase", new StringFunction(){

            public String evaluate(String value) {
                return value.toUpperCase();
            }
        });
        FunctionUtil.putFunction("lowercase", new StringFunction(){

            public String evaluate(String value) {
                return value.toLowerCase();
            }
        });
        FunctionUtil.putFunction("substring", new Function(){

            @Override
            public String evaluate(List<?> values) {
                if (values.size() != 3) {
                    throw new EvaluationException();
                }
                String value = FunctionUtil.asString(values.get(0));
                int position = FunctionUtil.asInteger(values.get(1));
                int length = FunctionUtil.asInteger(values.get(2));
                if (position <= 0 || length < 0) {
                    throw new EvaluationException();
                }
                return value.substring(position - 1, position + length - 1);
            }
        });
        FunctionUtil.putFunction("trimBlanks", new StringFunction(){

            public String evaluate(String value) {
                return value.trim();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class StringFunction
    implements Function {
        public abstract String evaluate(String var1);

        @Override
        public String evaluate(List<?> values) {
            if (values.size() != 1) {
                throw new EvaluationException();
            }
            return this.evaluate(FunctionUtil.asString(values.get(0)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ValueListFunction
    implements Function {
        public abstract Boolean evaluate(Object var1, List<?> var2);

        @Override
        public Boolean evaluate(List<?> values) {
            if (values.size() < 2) {
                throw new EvaluationException();
            }
            return this.evaluate(values.get(0), values.subList(1, values.size()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class UnaryBooleanFunction
    implements Function {
        public abstract Boolean evaluate(Boolean var1);

        @Override
        public Boolean evaluate(List<?> values) {
            if (values.size() != 1) {
                throw new EvaluationException();
            }
            return this.evaluate(FunctionUtil.asBoolean(values.get(0)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BinaryBooleanFunction
    implements Function {
        public abstract Boolean evaluate(Boolean var1, Boolean var2);

        @Override
        public Boolean evaluate(List<?> values) {
            if (values.size() < 2) {
                throw new EvaluationException();
            }
            Boolean result = FunctionUtil.asBoolean(values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                result = this.evaluate(result, FunctionUtil.asBoolean(values.get(i)));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ComparisonFunction
    implements Function {
        public abstract Boolean evaluate(int var1);

        public <C extends Comparable<C>> Boolean evaluate(C left, C right) {
            return this.evaluate(left.compareTo(right));
        }

        @Override
        public Boolean evaluate(List<?> values) {
            if (values.size() != 2) {
                throw new EvaluationException();
            }
            Object left = values.get(0);
            Object right = values.get(1);
            if (left == null || right == null) {
                throw new EvaluationException();
            }
            if (!left.getClass().equals(right.getClass())) {
                DataType dataType = ParameterUtil.getResultDataType(left, right);
                left = ParameterUtil.cast(dataType, left);
                right = ParameterUtil.cast(dataType, right);
            }
            return this.evaluate((Comparable)left, (Comparable)right);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ValueFunction
    implements Function {
        public abstract Boolean evaluate(Object var1);

        @Override
        public Boolean evaluate(List<?> values) {
            if (values.size() != 1) {
                throw new EvaluationException();
            }
            return this.evaluate(values.get(0));
        }
    }

    public static abstract class FpMathFunction
    extends MathFunction {
        public Number cast(DataType dataType, Number result) {
            return super.cast(FunctionUtil.integerToDouble(dataType), result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class MathFunction
    implements Function {
        public abstract Double evaluate(Number var1);

        public Number cast(DataType dataType, Number result) {
            return FunctionUtil.asNumber(ParameterUtil.cast(dataType, result));
        }

        @Override
        public Number evaluate(List<?> values) {
            if (values.size() != 1) {
                throw new EvaluationException();
            }
            Object value = values.get(0);
            DataType dataType = ParameterUtil.getDataType(value);
            return this.cast(dataType, this.evaluate(FunctionUtil.asNumber(value)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AggregateFunction
    implements Function {
        public abstract StorelessUnivariateStatistic createStatistic();

        public Number cast(DataType dataType, Double result) {
            return FunctionUtil.asNumber(ParameterUtil.cast(dataType, result));
        }

        @Override
        public Number evaluate(List<?> values) {
            StorelessUnivariateStatistic statistic = this.createStatistic();
            DataType dataType = null;
            for (Object value : values) {
                if (value == null) continue;
                statistic.increment(FunctionUtil.asNumber(value).doubleValue());
                if (dataType != null) {
                    dataType = ParameterUtil.getResultDataType(dataType, ParameterUtil.getDataType(value));
                    continue;
                }
                dataType = ParameterUtil.getDataType(value);
            }
            if (statistic.getN() == 0L) {
                throw new MissingResultException(null);
            }
            return this.cast(dataType, statistic.getResult());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ArithmeticFunction
    implements Function {
        public abstract Number evaluate(Number var1, Number var2);

        public Number cast(DataType dataType, Number result) {
            return FunctionUtil.asNumber(ParameterUtil.cast(dataType, result));
        }

        @Override
        public Number evaluate(List<?> values) {
            Number result;
            if (values.size() != 2) {
                throw new EvaluationException();
            }
            Object left = values.get(0);
            Object right = values.get(1);
            if (left == null || right == null) {
                return null;
            }
            DataType dataType = ParameterUtil.getResultDataType(left, right);
            try {
                result = this.evaluate(FunctionUtil.asNumber(left), FunctionUtil.asNumber(right));
            }
            catch (ArithmeticException ae) {
                throw new InvalidResultException(null);
            }
            return this.cast(dataType, result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Function {
        public Object evaluate(List<?> var1);
    }
}

