/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeatureType;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.HasReasonCode;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputUtil {
    private OutputUtil() {
    }

    public static Map<FieldName, Object> evaluate(Map<FieldName, ?> predictions, ModelManagerEvaluationContext context) {
        LinkedHashMap<FieldName, Object> result = new LinkedHashMap<FieldName, Object>(predictions);
        context = context.clone();
        ModelManager<?> modelManager = context.getModelManager();
        Output output = modelManager.getOrCreateOutput();
        List<OutputField> outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            Object value = null;
            ResultFeatureType resultFeature = outputField.getFeature();
            switch (resultFeature) {
                case PREDICTED_VALUE: 
                case PROBABILITY: 
                case ENTITY_ID: 
                case REASON_CODE: {
                    FieldName target = outputField.getTargetField();
                    if (target == null) {
                        target = modelManager.getTarget();
                    }
                    if (!predictions.containsKey(target)) {
                        throw new MissingFieldException(target, (PMMLObject)outputField);
                    }
                    value = predictions.get(target);
                    break;
                }
            }
            switch (resultFeature) {
                case PREDICTED_VALUE: {
                    value = OutputUtil.getResult(value);
                    break;
                }
                case TRANSFORMED_VALUE: {
                    Expression expression = outputField.getExpression();
                    if (expression == null) {
                        throw new InvalidFeatureException(outputField);
                    }
                    value = ExpressionUtil.evaluate(expression, (EvaluationContext)context);
                    break;
                }
                case PROBABILITY: {
                    value = OutputUtil.getProbability(value, outputField.getValue());
                    break;
                }
                case ENTITY_ID: {
                    value = OutputUtil.getEntityId(value);
                    break;
                }
                case REASON_CODE: {
                    value = OutputUtil.getReasonCode(value, outputField.getRank());
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException(outputField, resultFeature);
                }
            }
            FieldName name = outputField.getName();
            DataType dataType = outputField.getDataType();
            if (dataType != null) {
                value = ParameterUtil.cast(dataType, value);
            }
            result.put(name, value);
            context.putParameter(name, value);
        }
        return result;
    }

    private static Object getResult(Object object) {
        return EvaluatorUtil.decode(object);
    }

    private static Double getProbability(Object object, String value) {
        if (!(object instanceof HasProbability)) {
            throw new EvaluationException();
        }
        HasProbability hasProbability = (HasProbability)object;
        return hasProbability.getProbability(value);
    }

    private static String getEntityId(Object object) {
        if (!(object instanceof HasEntityId)) {
            throw new EvaluationException();
        }
        HasEntityId hasEntityId = (HasEntityId)object;
        return hasEntityId.getEntityId();
    }

    public static String getReasonCode(Object object, int rank) {
        if (!(object instanceof HasReasonCode)) {
            throw new EvaluationException();
        }
        HasReasonCode hasReasonCode = (HasReasonCode)object;
        return hasReasonCode.getReasonCode(rank);
    }
}

