/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.HasReasonCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Score
implements Computable<Double>,
HasReasonCode {
    private Double value = null;
    private List<String> reasonCodeRanking = null;

    Score(Double value, List<String> reasonCodeRanking) {
        this.setValue(value);
        this.setReasonCodeRanking(reasonCodeRanking);
    }

    @Override
    public Double getResult() {
        return this.getValue();
    }

    @Override
    public String getReasonCode(int rank) {
        if (rank < 1) {
            throw new IllegalArgumentException();
        }
        int index = rank - 1;
        List<String> reasonCodeRanking = this.getReasonCodeRanking();
        if (reasonCodeRanking.size() > 0) {
            if (index < reasonCodeRanking.size()) {
                return reasonCodeRanking.get(index);
            }
            return reasonCodeRanking.get(reasonCodeRanking.size() - 1);
        }
        return null;
    }

    public Double getValue() {
        return this.value;
    }

    private void setValue(Double value) {
        this.value = value;
    }

    public List<String> getReasonCodeRanking() {
        return this.reasonCodeRanking;
    }

    private void setReasonCodeRanking(List<String> reasonCodeRanking) {
        this.reasonCodeRanking = reasonCodeRanking;
    }
}

