/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Node;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.TreeModel;
import org.dmg.pmml.True;
import org.jpmml.manager.EntityRegistry;
import org.jpmml.manager.ModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeModelManager
extends ModelManager<TreeModel>
implements EntityRegistry<Node> {
    private TreeModel treeModel = null;

    public TreeModelManager() {
    }

    public TreeModelManager(PMML pmml) {
        this(pmml, TreeModelManager.find(pmml.getContent(), TreeModel.class));
    }

    public TreeModelManager(PMML pmml, TreeModel treeModel) {
        super(pmml);
        this.treeModel = treeModel;
    }

    @Override
    public String getSummary() {
        return "Tree";
    }

    @Override
    public TreeModel getModel() {
        TreeModelManager.ensureNotNull(this.treeModel);
        return this.treeModel;
    }

    public TreeModel createClassificationModel() {
        return this.createModel(MiningFunctionType.CLASSIFICATION);
    }

    public TreeModel createModel(MiningFunctionType miningFunction) {
        TreeModelManager.ensureNull(this.treeModel);
        Node root = new Node();
        root.setPredicate(new True());
        this.treeModel = new TreeModel(new MiningSchema(), root, miningFunction);
        this.getModels().add(this.treeModel);
        return this.treeModel;
    }

    public Node getRoot() {
        TreeModel treeModel = this.getModel();
        Node root = treeModel.getNode();
        TreeModelManager.ensureNotNull(root);
        return root;
    }

    @Override
    public Map<String, Node> getEntities() {
        LinkedHashMap<String, Node> result = new LinkedHashMap<String, Node>();
        TreeModelManager.collectNodes(this.getRoot(), result);
        return result;
    }

    public Node addNode(String id, Predicate predicate) {
        return this.addNode(this.getRoot(), id, predicate);
    }

    public Node addNode(Node parentNode, String id, Predicate predicate) {
        Node node = new Node();
        node.setId(id);
        node.setPredicate(predicate);
        parentNode.getNodes().add(node);
        return node;
    }

    public ScoreDistribution getOrAddScoreDistribution(Node node, String value) {
        List<ScoreDistribution> scoreDistributions = node.getScoreDistributions();
        for (ScoreDistribution scoreDistribution : scoreDistributions) {
            if (!scoreDistribution.getValue().equals(value)) continue;
            return scoreDistribution;
        }
        ScoreDistribution scoreDistribution = new ScoreDistribution(value, 0.0);
        scoreDistributions.add(scoreDistribution);
        return scoreDistribution;
    }

    private static void collectNodes(Node node, Map<String, Node> map) {
        TreeModelManager.putEntity(node, map);
        List<Node> children = node.getNodes();
        for (Node child : children) {
            TreeModelManager.collectNodes(child, map);
        }
    }
}

