/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FunctionUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.NormalizationUtil;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.manager.UnsupportedFeatureException;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static Object evaluate(FieldName name, EvaluationContext context) {
        DerivedField derivedField = context.resolveField(name);
        if (derivedField != null) {
            return ExpressionUtil.evaluate(derivedField, context);
        }
        return context.getArgument(name);
    }

    public static Object evaluate(DerivedField derivedField, EvaluationContext context) {
        Object value = ExpressionUtil.evaluate(derivedField.getExpression(), context);
        DataType dataType = derivedField.getDataType();
        if (dataType != null) {
            value = ParameterUtil.cast(dataType, value);
        }
        return value;
    }

    public static Object evaluate(Expression expression, EvaluationContext context) {
        if (expression instanceof Constant) {
            return ExpressionUtil.evaluateConstant((Constant)expression, context);
        }
        if (expression instanceof FieldRef) {
            return ExpressionUtil.evaluateFieldRef((FieldRef)expression, context);
        }
        if (expression instanceof NormContinuous) {
            return ExpressionUtil.evaluateNormContinuous((NormContinuous)expression, context);
        }
        if (expression instanceof NormDiscrete) {
            return ExpressionUtil.evaluateNormDiscrete((NormDiscrete)expression, context);
        }
        if (expression instanceof Discretize) {
            return ExpressionUtil.evaluateDiscretize((Discretize)expression, context);
        }
        if (expression instanceof MapValues) {
            return ExpressionUtil.evaluateMapValues((MapValues)expression, context);
        }
        if (expression instanceof Apply) {
            return ExpressionUtil.evaluateApply((Apply)expression, context);
        }
        throw new UnsupportedFeatureException(expression);
    }

    public static Object evaluateConstant(Constant constant, EvaluationContext context) {
        String value = constant.getValue();
        DataType dataType = constant.getDataType();
        if (dataType == null) {
            dataType = ParameterUtil.getConstantDataType(value);
        }
        return ParameterUtil.parse(dataType, value);
    }

    public static Object evaluateFieldRef(FieldRef fieldRef, EvaluationContext context) {
        Object value = ExpressionUtil.evaluate(fieldRef.getField(), context);
        if (value == null) {
            return fieldRef.getMapMissingTo();
        }
        return value;
    }

    public static Object evaluateNormContinuous(NormContinuous normContinuous, EvaluationContext context) {
        Number value = (Number)ExpressionUtil.evaluate(normContinuous.getField(), context);
        if (value == null) {
            return normContinuous.getMapMissingTo();
        }
        return NormalizationUtil.normalize(normContinuous, value.doubleValue());
    }

    public static Object evaluateNormDiscrete(NormDiscrete normDiscrete, EvaluationContext context) {
        Object value = ExpressionUtil.evaluate(normDiscrete.getField(), context);
        if (value == null) {
            return normDiscrete.getMapMissingTo();
        }
        boolean equals = ParameterUtil.equals(value, normDiscrete.getValue());
        return equals ? 1.0 : 0.0;
    }

    public static Object evaluateDiscretize(Discretize discretize, EvaluationContext context) {
        DataType dataType = discretize.getDataType();
        Object value = ExpressionUtil.evaluate(discretize.getField(), context);
        if (value == null) {
            return ExpressionUtil.parseSafely(dataType, discretize.getMapMissingTo());
        }
        String result = DiscretizationUtil.discretize(discretize, value);
        return ExpressionUtil.parseSafely(dataType, result);
    }

    public static Object evaluateMapValues(MapValues mapValues, EvaluationContext context) {
        DataType dataType = mapValues.getDataType();
        LinkedHashMap<String, Object> values = Maps.newLinkedHashMap();
        List<FieldColumnPair> fieldColumnPairs = mapValues.getFieldColumnPairs();
        for (FieldColumnPair fieldColumnPair : fieldColumnPairs) {
            Object value = ExpressionUtil.evaluate(fieldColumnPair.getField(), context);
            if (value == null) {
                return ExpressionUtil.parseSafely(dataType, mapValues.getMapMissingTo());
            }
            values.put(fieldColumnPair.getColumn(), value);
        }
        String result = DiscretizationUtil.mapValue(mapValues, values);
        return ExpressionUtil.parseSafely(dataType, result);
    }

    public static Object evaluateApply(Apply apply, EvaluationContext context) {
        Object result;
        ArrayList<Object> values = Lists.newArrayList();
        List<Expression> arguments = apply.getExpressions();
        for (Expression argument : arguments) {
            Object value = ExpressionUtil.evaluate(argument, context);
            values.add(value);
        }
        try {
            result = FunctionUtil.evaluate(apply, values, context);
        }
        catch (InvalidResultException ire) {
            InvalidValueTreatmentMethodType invalidValueTreatmentMethod = apply.getInvalidValueTreatment();
            switch (invalidValueTreatmentMethod) {
                case RETURN_INVALID: {
                    throw new InvalidResultException(apply);
                }
                case AS_IS: {
                    throw ire;
                }
                case AS_MISSING: {
                    return apply.getMapMissingTo();
                }
            }
            throw new UnsupportedFeatureException(apply, invalidValueTreatmentMethod);
        }
        if (result == null) {
            return apply.getMapMissingTo();
        }
        return result;
    }

    private static Object parseSafely(DataType dataType, String value) {
        if (value != null && dataType != null) {
            return ParameterUtil.parse(dataType, value);
        }
        return value;
    }
}

