/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Product;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.ParameterField;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Seconds;
import org.jpmml.evaluator.DaysSinceDate;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FunctionEvaluationContext;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MissingResultException;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.evaluator.SecondsSinceDate;
import org.jpmml.evaluator.SecondsSinceMidnight;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class FunctionUtil {
    private static final Map<String, Function> functions = Maps.newLinkedHashMap();

    private FunctionUtil() {
    }

    public static Object evaluate(Apply apply, List<?> values, EvaluationContext context) {
        String name = apply.getFunction();
        Function function = FunctionUtil.getFunction(name);
        if (function == null) {
            DefineFunction defineFunction = context.resolveFunction(name);
            if (defineFunction == null) {
                throw new UnsupportedFeatureException(apply);
            }
            return FunctionUtil.evaluate(defineFunction, values, context);
        }
        return function.evaluate(values);
    }

    public static Object evaluate(DefineFunction defineFunction, List<?> values, EvaluationContext context) {
        DataType dataType;
        List<ParameterField> parameterFields = defineFunction.getParameterFields();
        if (parameterFields.size() < 1) {
            throw new InvalidFeatureException(defineFunction);
        }
        if (parameterFields.size() != values.size()) {
            throw new EvaluationException();
        }
        LinkedHashMap<FieldName, ?> arguments = Maps.newLinkedHashMap();
        for (int i = 0; i < parameterFields.size(); ++i) {
            ParameterField parameterField = parameterFields.get(i);
            Object value = values.get(i);
            dataType = parameterField.getDataType();
            if (dataType != null) {
                value = ParameterUtil.cast(dataType, value);
            }
            arguments.put(parameterField.getName(), value);
        }
        Expression expression = defineFunction.getExpression();
        if (expression == null) {
            throw new InvalidFeatureException(defineFunction);
        }
        FunctionEvaluationContext functionContext = new FunctionEvaluationContext(context, arguments);
        Object result = ExpressionUtil.evaluate(expression, (EvaluationContext)functionContext);
        dataType = defineFunction.getDataType();
        if (dataType != null) {
            result = ParameterUtil.cast(dataType, result);
        }
        return result;
    }

    public static Function getFunction(String name) {
        return functions.get(name);
    }

    public static void putFunction(String name, Function function) {
        functions.put(name, function);
    }

    private static Boolean asBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new EvaluationException();
    }

    private static Number asNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new EvaluationException();
    }

    private static Integer asInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new EvaluationException();
    }

    private static String asString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new EvaluationException();
    }

    private static LocalDate asDate(Object value) {
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime instant = (LocalDateTime)value;
            return instant.toLocalDate();
        }
        throw new EvaluationException();
    }

    private static LocalTime asTime(Object value) {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime instant = (LocalDateTime)value;
            return instant.toLocalTime();
        }
        throw new EvaluationException();
    }

    private static LocalDateTime asDateTime(Object value) {
        if (value instanceof LocalDate) {
            LocalDate instant = (LocalDate)value;
            return new LocalDateTime(instant.getYear(), instant.getMonthOfYear(), instant.getDayOfMonth(), 0, 0, 0);
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        throw new EvaluationException();
    }

    private static Number cast(DataType dataType, Number number) {
        switch (dataType) {
            case INTEGER: {
                if (number instanceof Integer) {
                    return number;
                }
                return number.intValue();
            }
            case FLOAT: {
                if (number instanceof Float) {
                    return number;
                }
                return Float.valueOf(number.floatValue());
            }
            case DOUBLE: {
                if (number instanceof Double) {
                    return number;
                }
                return number.doubleValue();
            }
        }
        throw new EvaluationException();
    }

    private static DataType integerToDouble(DataType dataType) {
        switch (dataType) {
            case INTEGER: {
                return DataType.DOUBLE;
            }
        }
        return dataType;
    }

    static {
        FunctionUtil.putFunction("+", new ArithmeticFunction(){

            @Override
            public Double evaluate(Number left, Number right) {
                return left.doubleValue() + right.doubleValue();
            }
        });
        FunctionUtil.putFunction("-", new ArithmeticFunction(){

            @Override
            public Double evaluate(Number left, Number right) {
                return left.doubleValue() - right.doubleValue();
            }
        });
        FunctionUtil.putFunction("*", new ArithmeticFunction(){

            @Override
            public Double evaluate(Number left, Number right) {
                return left.doubleValue() * right.doubleValue();
            }
        });
        FunctionUtil.putFunction("/", new ArithmeticFunction(){

            @Override
            public Number evaluate(Number left, Number right) {
                if (left instanceof Integer && right instanceof Integer) {
                    return left.intValue() / right.intValue();
                }
                return left.doubleValue() / right.doubleValue();
            }
        });
        FunctionUtil.putFunction("min", new AggregateFunction(){

            @Override
            public Min createStatistic() {
                return new Min();
            }
        });
        FunctionUtil.putFunction("max", new AggregateFunction(){

            @Override
            public Max createStatistic() {
                return new Max();
            }
        });
        FunctionUtil.putFunction("avg", new AggregateFunction(){

            @Override
            public Mean createStatistic() {
                return new Mean();
            }

            @Override
            public DataType getResultType(DataType dataType) {
                return FunctionUtil.integerToDouble(dataType);
            }
        });
        FunctionUtil.putFunction("sum", new AggregateFunction(){

            @Override
            public Sum createStatistic() {
                return new Sum();
            }
        });
        FunctionUtil.putFunction("product", new AggregateFunction(){

            @Override
            public Product createStatistic() {
                return new Product();
            }
        });
        FunctionUtil.putFunction("log10", new FpMathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.log10(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("ln", new FpMathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.log(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("exp", new FpMathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.exp(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("sqrt", new FpMathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.sqrt(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("abs", new MathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.abs(value.doubleValue());
            }
        });
        FunctionUtil.putFunction("pow", new Function(){

            @Override
            public Number evaluate(List<?> values) {
                if (values.size() != 2) {
                    throw new EvaluationException();
                }
                Number left = FunctionUtil.asNumber(values.get(0));
                Number right = FunctionUtil.asNumber(values.get(1));
                DataType dataType = ParameterUtil.getResultDataType(left, right);
                Double result = Math.pow(left.doubleValue(), right.doubleValue());
                return FunctionUtil.cast(dataType, result);
            }
        });
        FunctionUtil.putFunction("threshold", new Function(){

            @Override
            public Number evaluate(List<?> values) {
                if (values.size() != 2) {
                    throw new EvaluationException();
                }
                Number left = FunctionUtil.asNumber(values.get(0));
                Number right = FunctionUtil.asNumber(values.get(1));
                DataType dataType = ParameterUtil.getResultDataType(left, right);
                Integer result = left.doubleValue() > right.doubleValue() ? 1 : 0;
                return FunctionUtil.cast(dataType, result);
            }
        });
        FunctionUtil.putFunction("floor", new MathFunction(){

            @Override
            public Double evaluate(Number number) {
                return Math.floor(number.doubleValue());
            }
        });
        FunctionUtil.putFunction("ceil", new MathFunction(){

            @Override
            public Double evaluate(Number number) {
                return Math.ceil(number.doubleValue());
            }
        });
        FunctionUtil.putFunction("round", new MathFunction(){

            @Override
            public Double evaluate(Number number) {
                return Math.round(number.doubleValue());
            }
        });
        FunctionUtil.putFunction("isMissing", new ValueFunction(){

            @Override
            public Boolean evaluate(Object value) {
                return value == null;
            }
        });
        FunctionUtil.putFunction("isNotMissing", new ValueFunction(){

            @Override
            public Boolean evaluate(Object value) {
                return value != null;
            }
        });
        FunctionUtil.putFunction("equal", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order == 0;
            }
        });
        FunctionUtil.putFunction("notEqual", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order != 0;
            }
        });
        FunctionUtil.putFunction("lessThan", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order < 0;
            }
        });
        FunctionUtil.putFunction("lessOrEqual", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order <= 0;
            }
        });
        FunctionUtil.putFunction("greaterThan", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order > 0;
            }
        });
        FunctionUtil.putFunction("greaterOrEqual", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order >= 0;
            }
        });
        FunctionUtil.putFunction("and", new BinaryBooleanFunction(){

            @Override
            public Boolean evaluate(Boolean left, Boolean right) {
                return left & right;
            }
        });
        FunctionUtil.putFunction("or", new BinaryBooleanFunction(){

            @Override
            public Boolean evaluate(Boolean left, Boolean right) {
                return left | right;
            }
        });
        FunctionUtil.putFunction("not", new UnaryBooleanFunction(){

            @Override
            public Boolean evaluate(Boolean value) {
                return value == false;
            }
        });
        FunctionUtil.putFunction("isIn", new ValueListFunction(){

            @Override
            public Boolean evaluate(Object value, List<?> values) {
                return values.contains(value);
            }
        });
        FunctionUtil.putFunction("isNotIn", new ValueListFunction(){

            @Override
            public Boolean evaluate(Object value, List<?> values) {
                return !values.contains(value);
            }
        });
        FunctionUtil.putFunction("if", new Function(){

            @Override
            public Object evaluate(List<?> values) {
                if (values.size() < 2 || values.size() > 3) {
                    throw new EvaluationException();
                }
                Boolean flag = FunctionUtil.asBoolean(values.get(0));
                if (flag.booleanValue()) {
                    return values.get(1);
                }
                if (values.size() > 2) {
                    return values.get(2);
                }
                return null;
            }
        });
        FunctionUtil.putFunction("uppercase", new StringFunction(){

            @Override
            public String evaluate(String value) {
                return value.toUpperCase();
            }
        });
        FunctionUtil.putFunction("lowercase", new StringFunction(){

            @Override
            public String evaluate(String value) {
                return value.toLowerCase();
            }
        });
        FunctionUtil.putFunction("substring", new Function(){

            @Override
            public String evaluate(List<?> values) {
                if (values.size() != 3) {
                    throw new EvaluationException();
                }
                String value = FunctionUtil.asString(values.get(0));
                int position = FunctionUtil.asInteger(values.get(1));
                int length = FunctionUtil.asInteger(values.get(2));
                if (position <= 0 || length < 0) {
                    throw new EvaluationException();
                }
                return value.substring(position - 1, position + length - 1);
            }
        });
        FunctionUtil.putFunction("trimBlanks", new StringFunction(){

            @Override
            public String evaluate(String value) {
                return value.trim();
            }
        });
        FunctionUtil.putFunction("dateDaysSinceYear", new Function(){

            @Override
            public Integer evaluate(List<?> values) {
                if (values.size() != 2) {
                    throw new EvaluationException();
                }
                LocalDate instant = FunctionUtil.asDate(values.get(0));
                int year = FunctionUtil.asInteger(values.get(1));
                DaysSinceDate period = new DaysSinceDate(year, instant);
                return period.intValue();
            }
        });
        FunctionUtil.putFunction("dateSecondsSinceMidnight", new Function(){

            @Override
            public Integer evaluate(List<?> values) {
                if (values.size() != 1) {
                    throw new EvaluationException();
                }
                LocalTime instant = FunctionUtil.asTime(values.get(0));
                Seconds seconds = Seconds.seconds(instant.getHourOfDay() * 60 * 60 + instant.getMinuteOfHour() * 60 + instant.getSecondOfMinute());
                SecondsSinceMidnight period = new SecondsSinceMidnight(seconds);
                return period.intValue();
            }
        });
        FunctionUtil.putFunction("dateSecondsSinceYear", new Function(){

            @Override
            public Integer evaluate(List<?> values) {
                if (values.size() != 2) {
                    throw new EvaluationException();
                }
                LocalDateTime instant = FunctionUtil.asDateTime(values.get(0));
                int year = FunctionUtil.asInteger(values.get(1));
                SecondsSinceDate period = new SecondsSinceDate(year, instant);
                return period.intValue();
            }
        });
    }

    public static abstract class StringFunction
    implements Function {
        public abstract String evaluate(String var1);

        @Override
        public String evaluate(List<?> values) {
            if (values.size() != 1) {
                throw new EvaluationException();
            }
            return this.evaluate(FunctionUtil.asString(values.get(0)));
        }
    }

    public static abstract class ValueListFunction
    implements Function {
        public abstract Boolean evaluate(Object var1, List<?> var2);

        @Override
        public Boolean evaluate(List<?> values) {
            if (values.size() < 2) {
                throw new EvaluationException();
            }
            return this.evaluate(values.get(0), values.subList(1, values.size()));
        }
    }

    public static abstract class UnaryBooleanFunction
    implements Function {
        public abstract Boolean evaluate(Boolean var1);

        @Override
        public Boolean evaluate(List<?> values) {
            if (values.size() != 1) {
                throw new EvaluationException();
            }
            return this.evaluate(FunctionUtil.asBoolean(values.get(0)));
        }
    }

    public static abstract class BinaryBooleanFunction
    implements Function {
        public abstract Boolean evaluate(Boolean var1, Boolean var2);

        @Override
        public Boolean evaluate(List<?> values) {
            if (values.size() < 2) {
                throw new EvaluationException();
            }
            Boolean result = FunctionUtil.asBoolean(values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                result = this.evaluate(result, FunctionUtil.asBoolean(values.get(i)));
            }
            return result;
        }
    }

    public static abstract class ComparisonFunction
    implements Function {
        public abstract Boolean evaluate(int var1);

        @Override
        public Boolean evaluate(List<?> values) {
            if (values.size() != 2) {
                throw new EvaluationException();
            }
            Object left = values.get(0);
            Object right = values.get(1);
            if (left == null || right == null) {
                throw new EvaluationException();
            }
            DataType dataType = ParameterUtil.getResultDataType(left, right);
            int order = ParameterUtil.compare(dataType, left, right);
            return this.evaluate(order);
        }
    }

    public static abstract class ValueFunction
    implements Function {
        public abstract Boolean evaluate(Object var1);

        @Override
        public Boolean evaluate(List<?> values) {
            if (values.size() != 1) {
                throw new EvaluationException();
            }
            return this.evaluate(values.get(0));
        }
    }

    public static abstract class FpMathFunction
    extends MathFunction {
        @Override
        public DataType getResultType(DataType dataType) {
            return FunctionUtil.integerToDouble(dataType);
        }
    }

    public static abstract class MathFunction
    implements Function {
        public abstract Double evaluate(Number var1);

        public DataType getResultType(DataType dataType) {
            return dataType;
        }

        @Override
        public Number evaluate(List<?> values) {
            if (values.size() != 1) {
                throw new EvaluationException();
            }
            Object value = values.get(0);
            DataType dataType = ParameterUtil.getDataType(value);
            return FunctionUtil.cast(this.getResultType(dataType), this.evaluate(FunctionUtil.asNumber(value)));
        }
    }

    public static abstract class AggregateFunction
    implements Function {
        public abstract StorelessUnivariateStatistic createStatistic();

        public DataType getResultType(DataType dataType) {
            return dataType;
        }

        @Override
        public Number evaluate(List<?> values) {
            StorelessUnivariateStatistic statistic = this.createStatistic();
            DataType dataType = null;
            for (Object value : values) {
                if (value == null) continue;
                statistic.increment(FunctionUtil.asNumber(value).doubleValue());
                if (dataType != null) {
                    dataType = ParameterUtil.getResultDataType(dataType, ParameterUtil.getDataType(value));
                    continue;
                }
                dataType = ParameterUtil.getDataType(value);
            }
            if (statistic.getN() == 0L) {
                throw new MissingResultException(null);
            }
            return FunctionUtil.cast(this.getResultType(dataType), statistic.getResult());
        }
    }

    public static abstract class ArithmeticFunction
    implements Function {
        public abstract Number evaluate(Number var1, Number var2);

        @Override
        public Number evaluate(List<?> values) {
            Number result;
            if (values.size() != 2) {
                throw new EvaluationException();
            }
            Object left = values.get(0);
            Object right = values.get(1);
            if (left == null || right == null) {
                return null;
            }
            DataType dataType = ParameterUtil.getResultDataType(left, right);
            try {
                result = this.evaluate(FunctionUtil.asNumber(left), FunctionUtil.asNumber(right));
            }
            catch (ArithmeticException ae) {
                throw new InvalidResultException(null);
            }
            return FunctionUtil.cast(dataType, result);
        }
    }

    public static interface Function {
        public Object evaluate(List<?> var1);
    }
}

