/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.dmg.pmml.Value;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Seconds;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.jpmml.evaluator.DaysSinceDate;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.SecondsSinceDate;
import org.jpmml.evaluator.SecondsSinceMidnight;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class ParameterUtil {
    private static final List<DataType> precedenceSequence = Arrays.asList(DataType.STRING, DataType.DOUBLE, DataType.FLOAT, DataType.INTEGER);
    private static final LocalDate YEAR_1960 = new LocalDate(1960, 1, 1);
    private static final LocalDate YEAR_1970 = new LocalDate(1970, 1, 1);
    private static final LocalDate YEAR_1980 = new LocalDate(1980, 1, 1);

    private ParameterUtil() {
    }

    public static Object prepare(DataField dataField, MiningField miningField, Object value) {
        if (dataField == null) {
            throw new InvalidFeatureException(dataField);
        }
        if (ParameterUtil.isOutlier(dataField, value)) {
            if (miningField == null) {
                throw new InvalidFeatureException(miningField);
            }
            OutlierTreatmentMethodType outlierTreatmentMethod = miningField.getOutlierTreatment();
            switch (outlierTreatmentMethod) {
                case AS_IS: {
                    break;
                }
                case AS_MISSING_VALUES: {
                    value = null;
                    break;
                }
                case AS_EXTREME_VALUES: {
                    Double lowValue = miningField.getLowValue();
                    Double highValue = miningField.getHighValue();
                    if (lowValue == null || highValue == null) {
                        throw new InvalidFeatureException(miningField);
                    }
                    DataType dataType = dataField.getDataType();
                    if (ParameterUtil.compare(dataType, value, lowValue) < 0) {
                        value = lowValue;
                        break;
                    }
                    if (ParameterUtil.compare(dataType, value, highValue) <= 0) break;
                    value = highValue;
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException(miningField, outlierTreatmentMethod);
                }
            }
        }
        if (ParameterUtil.isMissing(dataField, value)) {
            if (miningField == null) {
                return null;
            }
            value = miningField.getMissingValueReplacement();
            if (value == null) {
                return null;
            }
        }
        if (ParameterUtil.isInvalid(dataField, value)) {
            if (miningField == null) {
                throw new InvalidFeatureException(miningField);
            }
            InvalidValueTreatmentMethodType invalidValueTreatmentMethod = miningField.getInvalidValueTreatment();
            switch (invalidValueTreatmentMethod) {
                case RETURN_INVALID: {
                    throw new InvalidResultException(miningField);
                }
                case AS_IS: {
                    break;
                }
                case AS_MISSING: {
                    value = miningField.getMissingValueReplacement();
                    if (value != null) break;
                    return null;
                }
                default: {
                    throw new UnsupportedFeatureException(miningField, invalidValueTreatmentMethod);
                }
            }
        }
        return ParameterUtil.cast(dataField.getDataType(), value);
    }

    public static boolean isOutlier(DataField dataField, Object value) {
        if (value == null) {
            return false;
        }
        OpType opType = dataField.getOptype();
        switch (opType) {
            case CONTINUOUS: {
                Double minValue;
                ArrayList<Double> range = Lists.newArrayList();
                List<Interval> fieldIntervals = dataField.getIntervals();
                for (Interval fieldInterval : fieldIntervals) {
                    range.add(fieldInterval.getLeftMargin());
                    range.add(fieldInterval.getRightMargin());
                }
                List<Value> fieldValues = dataField.getValues();
                for (Value fieldValue : fieldValues) {
                    Value.Property property = fieldValue.getProperty();
                    switch (property) {
                        case VALID: {
                            range.add(ParameterUtil.toDouble(fieldValue.getValue()));
                            break;
                        }
                    }
                }
                if (range.isEmpty()) {
                    return false;
                }
                Double doubleValue = ParameterUtil.toDouble(value);
                if (doubleValue.compareTo(minValue = (Double)Collections.min(range)) < 0) {
                    return true;
                }
                Double maxValue = (Double)Collections.max(range);
                if (doubleValue.compareTo(maxValue) <= 0) break;
                return true;
            }
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException(dataField, opType);
            }
        }
        return false;
    }

    public static boolean isMissing(DataField dataField, Object value) {
        if (value == null) {
            return true;
        }
        List<Value> fieldValues = dataField.getValues();
        block3: for (Value fieldValue : fieldValues) {
            Value.Property property = fieldValue.getProperty();
            switch (property) {
                case MISSING: {
                    boolean equals = ParameterUtil.equals(DataType.STRING, value, fieldValue.getValue());
                    if (!equals) continue block3;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isInvalid(DataField dataField, Object value) {
        if (value == null) {
            return false;
        }
        return !ParameterUtil.isValid(dataField, value);
    }

    public static boolean isValid(DataField dataField, Object value) {
        if (value == null) {
            return false;
        }
        DataType dataType = dataField.getDataType();
        value = ParameterUtil.cast(dataType, value);
        OpType opType = dataField.getOptype();
        switch (opType) {
            case CONTINUOUS: {
                Double doubleValue = ParameterUtil.toDouble(value);
                int intervalCount = 0;
                List<Interval> fieldIntervals = dataField.getIntervals();
                for (Interval fieldInterval : fieldIntervals) {
                    ++intervalCount;
                    if (!DiscretizationUtil.contains(fieldInterval, doubleValue)) continue;
                    return true;
                }
                if (intervalCount > 0) {
                    return false;
                }
            }
            case CATEGORICAL: 
            case ORDINAL: {
                int validValueCount = 0;
                List<Value> fieldValues = dataField.getValues();
                block10: for (Value fieldValue : fieldValues) {
                    Value.Property property = fieldValue.getProperty();
                    switch (property) {
                        case VALID: {
                            ++validValueCount;
                            boolean equals = ParameterUtil.equals(dataType, value, fieldValue.getValue());
                            if (!equals) continue block10;
                            return true;
                        }
                        case INVALID: {
                            boolean equals = ParameterUtil.equals(dataType, value, fieldValue.getValue());
                            if (!equals) continue block10;
                            return false;
                        }
                        case MISSING: {
                            break;
                        }
                        default: {
                            throw new UnsupportedFeatureException(fieldValue, property);
                        }
                    }
                }
                return validValueCount <= 0;
            }
            default: {
                throw new UnsupportedFeatureException(dataField, opType);
            }
        }
    }

    public static boolean equals(Object value, String string) {
        return ParameterUtil.equals(ParameterUtil.getDataType(value), value, string);
    }

    static boolean equals(DataType dataType, Object left, Object right) {
        return ParameterUtil.cast(dataType, left).equals(ParameterUtil.cast(dataType, right));
    }

    public static int compare(Object value, String string) {
        return ParameterUtil.compare(ParameterUtil.getDataType(value), value, string);
    }

    static int compare(DataType dataType, Object left, Object right) {
        return ((Comparable)ParameterUtil.cast(dataType, left)).compareTo((Comparable)ParameterUtil.cast(dataType, right));
    }

    public static Object parse(DataType dataType, String string) {
        switch (dataType) {
            case STRING: {
                return string;
            }
            case INTEGER: {
                return Integer.valueOf(string);
            }
            case FLOAT: {
                return Float.valueOf(string);
            }
            case DOUBLE: {
                return Double.valueOf(string);
            }
            case DATE: {
                return ParameterUtil.parseDate(string);
            }
            case TIME: {
                return ParameterUtil.parseTime(string);
            }
            case DATE_TIME: {
                return ParameterUtil.parseDateTime(string);
            }
            case DATE_DAYS_SINCE_1960: {
                return new DaysSinceDate(YEAR_1960, ParameterUtil.parseDate(string));
            }
            case DATE_DAYS_SINCE_1970: {
                return new DaysSinceDate(YEAR_1970, ParameterUtil.parseDate(string));
            }
            case DATE_DAYS_SINCE_1980: {
                return new DaysSinceDate(YEAR_1980, ParameterUtil.parseDate(string));
            }
            case TIME_SECONDS: {
                return new SecondsSinceMidnight(ParameterUtil.parseSeconds(string));
            }
            case DATE_TIME_SECONDS_SINCE_1960: {
                return new SecondsSinceDate(YEAR_1960, ParameterUtil.parseDateTime(string));
            }
            case DATE_TIME_SECONDS_SINCE_1970: {
                return new SecondsSinceDate(YEAR_1970, ParameterUtil.parseDateTime(string));
            }
            case DATE_TIME_SECONDS_SINCE_1980: {
                return new SecondsSinceDate(YEAR_1980, ParameterUtil.parseDateTime(string));
            }
        }
        throw new EvaluationException();
    }

    private static LocalDate parseDate(String string) {
        return LocalDate.parse(string);
    }

    private static LocalTime parseTime(String string) {
        return LocalTime.parse(string);
    }

    private static LocalDateTime parseDateTime(String string) {
        return LocalDateTime.parse(string);
    }

    private static Seconds parseSeconds(String string) {
        DateTimeFormatter format = SecondsSinceMidnight.getFormat();
        DateTimeParser parser = format.getParser();
        DateTimeParserBucket bucket = new DateTimeParserBucket(0L, null, null);
        bucket.setZone(null);
        int result = parser.parseInto(bucket, string, 0);
        if (result >= 0 && result >= string.length()) {
            long millis = bucket.computeMillis(true);
            return Seconds.seconds((int)(millis / 1000L));
        }
        throw new IllegalArgumentException(string);
    }

    public static DataType getDataType(Object value) {
        if (value instanceof String) {
            return DataType.STRING;
        }
        if (value instanceof Integer) {
            return DataType.INTEGER;
        }
        if (value instanceof Float) {
            return DataType.FLOAT;
        }
        if (value instanceof Double) {
            return DataType.DOUBLE;
        }
        if (value instanceof LocalDate) {
            return DataType.DATE;
        }
        if (value instanceof LocalTime) {
            return DataType.TIME;
        }
        if (value instanceof LocalDateTime) {
            return DataType.DATE_TIME;
        }
        if (value instanceof DaysSinceDate) {
            DaysSinceDate period = (DaysSinceDate)value;
            LocalDate epoch = period.getEpoch();
            if (epoch.equals(YEAR_1960)) {
                return DataType.DATE_DAYS_SINCE_1960;
            }
            if (epoch.equals(YEAR_1970)) {
                return DataType.DATE_DAYS_SINCE_1970;
            }
            if (epoch.equals(YEAR_1980)) {
                return DataType.DATE_DAYS_SINCE_1980;
            }
        } else {
            if (value instanceof SecondsSinceMidnight) {
                return DataType.TIME_SECONDS;
            }
            if (value instanceof SecondsSinceDate) {
                SecondsSinceDate period = (SecondsSinceDate)value;
                LocalDate epoch = period.getEpoch();
                if (epoch.equals(YEAR_1960)) {
                    return DataType.DATE_TIME_SECONDS_SINCE_1960;
                }
                if (epoch.equals(YEAR_1970)) {
                    return DataType.DATE_TIME_SECONDS_SINCE_1970;
                }
                if (epoch.equals(YEAR_1980)) {
                    return DataType.DATE_TIME_SECONDS_SINCE_1980;
                }
            }
        }
        throw new EvaluationException();
    }

    public static DataType getResultDataType(Object left, Object right) {
        return ParameterUtil.getResultDataType(ParameterUtil.getDataType(left), ParameterUtil.getDataType(right));
    }

    public static DataType getResultDataType(DataType left, DataType right) {
        if (left.equals((Object)right)) {
            return left;
        }
        List<DataType> dataTypes = precedenceSequence;
        for (DataType dataType : dataTypes) {
            if (!dataType.equals((Object)left) && !dataType.equals((Object)right)) continue;
            return dataType;
        }
        throw new EvaluationException();
    }

    public static Object cast(DataType dataType, Object value) {
        switch (dataType) {
            case STRING: {
                return ParameterUtil.toString(value);
            }
            case INTEGER: {
                return ParameterUtil.toInteger(value);
            }
            case FLOAT: {
                return ParameterUtil.toFloat(value);
            }
            case DOUBLE: {
                return ParameterUtil.toDouble(value);
            }
            case DATE: {
                return ParameterUtil.toDate(value);
            }
            case TIME: {
                return ParameterUtil.toTime(value);
            }
            case DATE_TIME: {
                return ParameterUtil.toDateTime(value);
            }
            case DATE_DAYS_SINCE_1960: {
                return ParameterUtil.toDaysSinceDate(value, YEAR_1960);
            }
            case DATE_DAYS_SINCE_1970: {
                return ParameterUtil.toDaysSinceDate(value, YEAR_1970);
            }
            case DATE_DAYS_SINCE_1980: {
                return ParameterUtil.toDaysSinceDate(value, YEAR_1980);
            }
            case TIME_SECONDS: {
                return ParameterUtil.toSecondsSinceMidnight(value);
            }
            case DATE_TIME_SECONDS_SINCE_1960: {
                return ParameterUtil.toSecondsSinceDate(value, YEAR_1960);
            }
            case DATE_TIME_SECONDS_SINCE_1970: {
                return ParameterUtil.toSecondsSinceDate(value, YEAR_1970);
            }
            case DATE_TIME_SECONDS_SINCE_1980: {
                return ParameterUtil.toSecondsSinceDate(value, YEAR_1980);
            }
        }
        throw new EvaluationException();
    }

    private static String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Double || value instanceof Float || value instanceof Integer) {
            Number number = (Number)value;
            return number.toString();
        }
        throw new EvaluationException();
    }

    private static Integer toInteger(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return Integer.valueOf(string);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new EvaluationException();
    }

    private static Float toFloat(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return Float.valueOf(string);
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Integer) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        throw new EvaluationException();
    }

    private static Double toDouble(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return Double.valueOf(string);
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float || value instanceof Integer) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        throw new EvaluationException();
    }

    private static LocalDate toDate(Object value) {
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        throw new EvaluationException();
    }

    private static LocalTime toTime(Object value) {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        throw new EvaluationException();
    }

    private static LocalDateTime toDateTime(Object value) {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        throw new EvaluationException();
    }

    private static DaysSinceDate toDaysSinceDate(Object value, LocalDate epoch) {
        DaysSinceDate period;
        if (value instanceof DaysSinceDate && (period = (DaysSinceDate)value).getEpoch().equals(epoch)) {
            return period;
        }
        throw new EvaluationException();
    }

    private static SecondsSinceMidnight toSecondsSinceMidnight(Object value) {
        if (value instanceof SecondsSinceMidnight) {
            return (SecondsSinceMidnight)value;
        }
        throw new EvaluationException();
    }

    private static SecondsSinceDate toSecondsSinceDate(Object value, LocalDate epoch) {
        SecondsSinceDate period;
        if (value instanceof SecondsSinceDate && (period = (SecondsSinceDate)value).getEpoch().equals(epoch)) {
            return period;
        }
        throw new EvaluationException();
    }

    public static DataType getConstantDataType(String string) {
        try {
            if (string.indexOf(46) > -1) {
                Float.parseFloat(string);
                return DataType.FLOAT;
            }
            Integer.parseInt(string);
            return DataType.INTEGER;
        }
        catch (NumberFormatException nfe) {
            return DataType.STRING;
        }
    }
}

