/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.Seconds;

public class SecondsSinceDate
implements Comparable<SecondsSinceDate> {
    private LocalDate epoch = null;
    private Seconds seconds = null;

    public SecondsSinceDate(int year, LocalDateTime dateTime) {
        this(new LocalDate(year, 1, 1), dateTime);
    }

    public SecondsSinceDate(LocalDate epoch, LocalDateTime dateTime) {
        this.setEpoch(epoch);
        LocalDateTime epochDateTime = new LocalDateTime(epoch.getYear(), epoch.getMonthOfYear(), epoch.getDayOfMonth(), 0, 0, 0);
        this.setSeconds(Seconds.secondsBetween(epochDateTime, dateTime));
    }

    @Override
    public int compareTo(SecondsSinceDate that) {
        if (!this.getEpoch().equals(that.getEpoch())) {
            throw new ClassCastException();
        }
        return this.getSeconds().compareTo(that.getSeconds());
    }

    public int hashCode() {
        return 37 * this.getEpoch().hashCode() + this.getSeconds().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof SecondsSinceDate) {
            SecondsSinceDate that = (SecondsSinceDate)object;
            return this.getEpoch().equals(that.getEpoch()) && this.getSeconds().equals(that.getSeconds());
        }
        return false;
    }

    public int intValue() {
        return this.getSeconds().getSeconds();
    }

    public LocalDate getEpoch() {
        return this.epoch;
    }

    private void setEpoch(LocalDate epoch) {
        this.epoch = epoch;
    }

    public Seconds getSeconds() {
        return this.seconds;
    }

    private void setSeconds(Seconds seconds) {
        this.seconds = seconds;
    }
}

