/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Entity;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.jpmml.manager.Consumer;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.PMMLManager;

public abstract class ModelManager<M extends Model>
extends PMMLManager
implements Consumer {
    public ModelManager() {
    }

    public ModelManager(PMML pmml) {
        super(pmml);
    }

    public abstract M getModel();

    public void addField(FieldName name, String displayName, OpType opType, DataType dataType, FieldUsageType fieldUsageType) {
        this.addDataField(name, displayName, opType, dataType);
        this.addMiningField(name, fieldUsageType);
    }

    @Override
    public List<FieldName> getActiveFields() {
        return this.getMiningFields(FieldUsageType.ACTIVE);
    }

    @Override
    public List<FieldName> getGroupFields() {
        return this.getMiningFields(FieldUsageType.GROUP);
    }

    @Override
    public FieldName getTargetField() {
        List<FieldName> predictedFields = this.getPredictedFields();
        if (predictedFields.size() < 1) {
            throw new InvalidFeatureException("No predicted fields", this.getMiningSchema());
        }
        if (predictedFields.size() > 1) {
            throw new InvalidFeatureException("Too many predicted fields", this.getMiningSchema());
        }
        return predictedFields.get(0);
    }

    @Override
    public List<FieldName> getPredictedFields() {
        return this.getMiningFields(FieldUsageType.PREDICTED);
    }

    public List<FieldName> getMiningFields(FieldUsageType fieldUsageType) {
        ArrayList<FieldName> result = new ArrayList<FieldName>();
        List<MiningField> miningFields = this.getMiningSchema().getMiningFields();
        for (MiningField miningField : miningFields) {
            if (!miningField.getUsageType().equals((Object)fieldUsageType)) continue;
            result.add(miningField.getName());
        }
        return result;
    }

    @Override
    public MiningField getMiningField(FieldName name) {
        List<MiningField> miningFields = this.getMiningSchema().getMiningFields();
        return ModelManager.find(miningFields, name);
    }

    public MiningField addMiningField(FieldName name, FieldUsageType usageType) {
        MiningField miningField = new MiningField(name);
        miningField.setUsageType(usageType);
        List<MiningField> miningFields = this.getMiningSchema().getMiningFields();
        miningFields.add(miningField);
        return miningField;
    }

    @Override
    public List<FieldName> getOutputFields() {
        ArrayList<FieldName> result = new ArrayList<FieldName>();
        Output output = this.getOrCreateOutput();
        List<OutputField> outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            result.add(outputField.getName());
        }
        return result;
    }

    @Override
    public OutputField getOutputField(FieldName name) {
        Output output = this.getOrCreateOutput();
        List<OutputField> outputFields = output.getOutputFields();
        return ModelManager.find(outputFields, name);
    }

    @Override
    public DerivedField resolveField(FieldName name) {
        LocalTransformations localTransformations = this.getOrCreateLocalTransformations();
        List<DerivedField> derivedFields = localTransformations.getDerivedFields();
        DerivedField derivedField = ModelManager.find(derivedFields, name);
        if (derivedField == null) {
            derivedField = super.resolveField(name);
        }
        return derivedField;
    }

    public MiningSchema getMiningSchema() {
        return ((Model)this.getModel()).getMiningSchema();
    }

    public LocalTransformations getOrCreateLocalTransformations() {
        M model = this.getModel();
        LocalTransformations localTransformations = ((Model)model).getLocalTransformations();
        if (localTransformations == null) {
            localTransformations = new LocalTransformations();
            ((Model)model).setLocalTransformations(localTransformations);
        }
        return localTransformations;
    }

    public Output getOrCreateOutput() {
        M model = this.getModel();
        Output output = ((Model)model).getOutput();
        if (output == null) {
            output = new Output();
            ((Model)model).setOutput(output);
        }
        return output;
    }

    protected static <E extends Entity> void putEntity(E entity, BiMap<String, E> map) {
        String id = entity.getId();
        if (id == null || map.containsKey(id)) {
            throw new InvalidFeatureException(entity);
        }
        map.put(id, entity);
    }
}

