/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.codemodel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class StringSourceFileObject
extends SimpleJavaFileObject {
    private String encoding = null;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream(){

        @Override
        public void close() throws IOException {
            super.close();
        }
    };

    public StringSourceFileObject(String name) {
        this(name, null);
    }

    public StringSourceFileObject(String name, String encoding) {
        super(URI.create("string:///" + name), JavaFileObject.Kind.SOURCE);
        this.setEncoding(encoding);
    }

    @Override
    public String getCharContent(boolean ignoreEncodingErrors) throws IOException {
        String encoding = this.getEncoding();
        String string = encoding != null ? this.buffer.toString(encoding) : this.buffer.toString();
        return string;
    }

    @Override
    public ByteArrayOutputStream openOutputStream() {
        this.buffer.reset();
        return this.buffer;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

