/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.codemodel;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JResourceFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Objects;
import org.jpmml.codemodel.JClassFile;
import org.jpmml.codemodel.Streamable;

public class JCodeModelClassLoader
extends ClassLoader {
    private JCodeModel codeModel = null;

    public JCodeModelClassLoader(JCodeModel codeModel) {
        this.setCodeModel(codeModel);
    }

    public JCodeModelClassLoader(ClassLoader parent, JCodeModel codeModel) {
        super(parent);
        this.setCodeModel(codeModel);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String simpleName;
        JPackage _package;
        JCodeModel codeModel = this.getCodeModel();
        int dot = name.lastIndexOf(46);
        if (dot > -1) {
            _package = codeModel._package(name.substring(0, dot));
            simpleName = name.substring(dot + 1);
        } else {
            _package = codeModel.rootPackage();
            simpleName = name;
        }
        JClassFile definedClazzClassFile = (JClassFile)JCodeModelClassLoader.findResourceFile(_package, simpleName + ".class");
        if (definedClazzClassFile == null) {
            throw new ClassNotFoundException(name);
        }
        byte[] bytes = definedClazzClassFile.getBytes();
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    @Override
    public URL findResource(String name) {
        JPackage _package;
        int slash;
        JCodeModel codeModel = this.getCodeModel();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((slash = name.lastIndexOf(47)) > -1) {
            _package = codeModel._package(name.substring(0, slash));
            name = name.substring(slash + 1);
        } else {
            _package = codeModel.rootPackage();
        }
        final JResourceFile resourceFile = JCodeModelClassLoader.findResourceFile(_package, name);
        if (resourceFile == null) {
            return null;
        }
        URLStreamHandler resourceFileHandler = new URLStreamHandler(){

            @Override
            public URLConnection openConnection(URL url) throws IOException {
                URLConnection result = new URLConnection(url){

                    @Override
                    public void connect() {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        byte[] bytes;
                        if (resourceFile instanceof Streamable) {
                            Streamable streamable = (Streamable)resourceFile;
                            return streamable.getInputStream();
                        }
                        try {
                            bytes = JCodeModelClassLoader.toByteArray(resourceFile);
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                        return new ByteArrayInputStream(bytes);
                    }
                };
                return result;
            }
        };
        try {
            return new URL((URL)null, "codemodel:" + name, resourceFileHandler);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        URL url = this.findResource(name);
        if (url != null) {
            return Collections.enumeration(Collections.singleton(url));
        }
        return Collections.emptyEnumeration();
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    private void setCodeModel(JCodeModel codeModel) {
        this.codeModel = Objects.requireNonNull(codeModel);
    }

    private static JResourceFile findResourceFile(JPackage _package, String name) {
        Iterator it = _package.propertyFiles();
        while (it.hasNext()) {
            JResourceFile resourceFile = (JResourceFile)it.next();
            if (!resourceFile.name().equals(name)) continue;
            return resourceFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toByteArray(JResourceFile resourceFile) throws Exception {
        Class<?> clazz = resourceFile.getClass();
        Method method = clazz.getDeclaredMethod("build", OutputStream.class);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            method.invoke((Object)resourceFile, os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

