/*
 * Decompiled with CFR 0.152.
 */
package joblib;

import java.io.IOException;
import java.io.InputStream;
import numpy.DType;
import numpy.core.NDArray;
import numpy.core.NDArrayUtil;
import org.jpmml.python.PyClassDict;

public class NumpyArrayWrapper
extends PyClassDict {
    public NumpyArrayWrapper(String module, String name) {
        super(module, name);
    }

    public NDArray toArray(InputStream is) throws IOException {
        DType dtype = this.getDType();
        Object[] shape = this.getShape();
        String order = this.getOrder();
        Object descr = dtype.toDescr();
        Boolean fortranOrder = NumpyArrayWrapper.parseOrder(order);
        Object data = NDArrayUtil.parseData(is, descr, shape);
        NDArray array = new NDArray();
        array.__setstate__(new Object[]{null, shape, descr, fortranOrder, data});
        return array;
    }

    public DType getDType() {
        return this.get("dtype", DType.class);
    }

    public Object[] getShape() {
        return this.getTuple("shape");
    }

    public String getOrder() {
        return this.getString("order");
    }

    private static Boolean parseOrder(String order) {
        switch (order) {
            case "C": {
                return Boolean.FALSE;
            }
            case "F": {
                return Boolean.TRUE;
            }
        }
        throw new IllegalArgumentException(order);
    }
}

