/*
 * Decompiled with CFR 0.152.
 */
package numpy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import numpy.core.TypeDescriptor;
import org.dmg.pmml.DataType;
import org.jpmml.python.CClassDict;

public class DType
extends CClassDict {
    private static final String[] INIT_ATTRIBUTES = new String[]{"obj", "align", "copy"};
    private static final String[] SETSTATE_ATTRIBUTES = new String[]{"version", "order", "subdescr", "names", "values", "w_size", "alignment", "flags"};
    private static final Set<String> TREE_KEYS = new LinkedHashSet<String>(Arrays.asList("left_child", "right_child", "feature", "threshold", "impurity", "n_node_samples", "weighted_n_node_samples"));
    private static final Set<String> NODEDATA_KEYS = new LinkedHashSet<String>(Arrays.asList("idx_start", "idx_end", "is_leaf", "radius"));
    private static final Set<String> NODESTRUCT_KEYS = new LinkedHashSet<String>(Arrays.asList("value", "count", "feature_idx", "threshold", "missing_go_to_left", "left", "right", "gain", "depth", "is_leaf", "bin_threshold"));

    public DType(String module, String name) {
        super(module, name);
    }

    @Override
    public void __init__(Object[] args) {
        super.__setstate__(DType.createAttributeMap(INIT_ATTRIBUTES, args));
    }

    @Override
    public void __setstate__(Object[] args) {
        super.__setstate__(DType.createAttributeMap(SETSTATE_ATTRIBUTES, args));
    }

    public DataType getDataType() {
        String className = this.getClassName();
        if ("numpy.dtype".equals(className)) {
            String obj = this.getObj();
            String order = this.getOrder();
            TypeDescriptor typeDescriptor = new TypeDescriptor(DType.formatDescr(obj, order));
            return typeDescriptor.getDataType();
        }
        switch (className) {
            case "builtins.bool": {
                return DataType.BOOLEAN;
            }
            case "builtins.float": {
                return DataType.DOUBLE;
            }
            case "builtins.int": {
                return DataType.INTEGER;
            }
            case "builtins.str": {
                return DataType.STRING;
            }
            case "numpy.bool_": {
                return DataType.BOOLEAN;
            }
            case "numpy.int_": 
            case "numpy.int8": 
            case "numpy.int16": 
            case "numpy.int32": 
            case "numpy.int64": {
                return DataType.INTEGER;
            }
            case "numpy.uint8": 
            case "numpy.uint16": 
            case "numpy.uint32": 
            case "numpy.uint64": {
                return DataType.INTEGER;
            }
            case "numpy.float32": {
                return DataType.FLOAT;
            }
            case "numpy.float_": 
            case "numpy.float64": {
                return DataType.DOUBLE;
            }
        }
        throw new IllegalArgumentException(className);
    }

    public Object toDescr() {
        Map<String, Object[]> values = this.getValues();
        if (values == null) {
            String obj = this.getObj();
            String order = this.getOrder();
            return DType.formatDescr(obj, order);
        }
        Set<String> valueKeys = values.keySet();
        if (TREE_KEYS.equals(valueKeys)) {
            return DType.formatDescr(TREE_KEYS, values);
        }
        if (NODEDATA_KEYS.equals(valueKeys)) {
            return DType.formatDescr(NODEDATA_KEYS, values);
        }
        if (NODESTRUCT_KEYS.equals(valueKeys)) {
            return DType.formatDescr(NODESTRUCT_KEYS, values);
        }
        throw new IllegalArgumentException();
    }

    public Map<String, Object[]> getValues() {
        return (Map)this.get("values");
    }

    public String getObj() {
        return (String)this.get("obj");
    }

    public String getOrder() {
        return (String)this.get("order");
    }

    private static List<Object[]> formatDescr(Collection<String> keys, Map<String, Object[]> values) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (String key : keys) {
            Object[] value = values.get(key);
            DType dType = (DType)((Object)value[0]);
            result.add(new Object[]{key, dType.toDescr()});
        }
        return result;
    }

    private static String formatDescr(String obj, String order) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        return order != null ? order + obj : obj;
    }
}

