/*
 * Decompiled with CFR 0.152.
 */
package numpy.core;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import numpy.DType;
import numpy.core.NDArrayUtil;
import org.jpmml.python.CClassDict;
import org.jpmml.python.HasArray;
import org.jpmml.python.HasContent;

public class Scalar
extends CClassDict
implements HasArray,
HasContent<List<?>> {
    private List<?> content = null;
    private static final String[] INIT_ATTRIBUTES = new String[]{"dtype", "obj"};

    public Scalar(String module, String name) {
        super(module, name);
    }

    @Override
    public void __init__(Object[] args) {
        super.__setstate__(Scalar.createAttributeMap(INIT_ATTRIBUTES, args));
    }

    @Override
    public List<?> getArrayContent() {
        Object content = this.getContent();
        return content;
    }

    @Override
    public int[] getArrayShape() {
        Object content = this.getContent();
        return new int[]{content.size()};
    }

    public Object getOnlyElement() {
        Object content = this.getContent();
        return Iterables.getOnlyElement((Iterable)content);
    }

    @Override
    public List<?> getContent() {
        if (this.content == null) {
            this.content = this.loadContent();
        }
        return this.content;
    }

    @Override
    public void clearContent() {
        this.content = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<?> loadContent() {
        DType dtype = this.getDType();
        byte[] obj = this.getObj();
        try (ByteArrayInputStream is = new ByteArrayInputStream(obj);){
            List list = (List)NDArrayUtil.parseData(is, (Object)dtype, new Object[0]);
            return list;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public DType getDType() {
        return (DType)((Object)this.get("dtype"));
    }

    public byte[] getObj() {
        Object obj = this.get("obj");
        if (obj instanceof String) {
            String string = (String)obj;
            return string.getBytes(Charsets.ISO_8859_1);
        }
        return (byte[])obj;
    }
}

