/*
 * Decompiled with CFR 0.152.
 */
package numpy.core;

import java.util.List;
import org.dmg.pmml.Expression;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.python.Identifiable;

public class FunctionUtil {
    private FunctionUtil() {
    }

    public static Expression encodeFunction(Identifiable identifiable, List<Expression> expressions) {
        return FunctionUtil.encodeFunction(identifiable.getModule(), identifiable.getName(), expressions);
    }

    public static Expression encodeFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("numpy") || module.startsWith("numpy.")) {
            return FunctionUtil.encodeNumpyFunction(name, expressions);
        }
        throw new IllegalArgumentException(module);
    }

    public static Expression encodeNumpyFunction(String name, List<Expression> expressions) {
        switch (name) {
            case "absolute": {
                return PMMLUtil.createApply((String)"abs", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "arccos": {
                return PMMLUtil.createApply((String)"acos", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "arcsin": {
                return PMMLUtil.createApply((String)"asin", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "arctan": {
                return PMMLUtil.createApply((String)"atan", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "arctan2": {
                return PMMLUtil.createApply((String)"x-atan2", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 2, 0), FunctionUtil.getElement(expressions, 2, 1)});
            }
            case "ceil": {
                return PMMLUtil.createApply((String)"ceil", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "clip": {
                return PMMLUtil.createApply((String)"min", (Expression[])new Expression[]{PMMLUtil.createApply((String)"max", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 3, 0), FunctionUtil.getElement(expressions, 3, 1)}), FunctionUtil.getElement(expressions, 3, 2)});
            }
            case "cos": {
                return PMMLUtil.createApply((String)"cos", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "cosh": {
                return PMMLUtil.createApply((String)"cosh", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "degrees": 
            case "rad2deg": {
                return PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), PMMLUtil.createConstant((Number)57.29577951308232)});
            }
            case "exp": {
                return PMMLUtil.createApply((String)"exp", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "expm1": {
                return PMMLUtil.createApply((String)"expm1", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "floor": {
                return PMMLUtil.createApply((String)"floor", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "fmax": {
                return PMMLUtil.createApply((String)"max", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 2, 0), FunctionUtil.getElement(expressions, 2, 1)});
            }
            case "fmin": {
                return PMMLUtil.createApply((String)"min", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 2, 0), FunctionUtil.getElement(expressions, 2, 1)});
            }
            case "hypot": {
                return PMMLUtil.createApply((String)"hypot", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "log": {
                return PMMLUtil.createApply((String)"ln", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "log1p": {
                return PMMLUtil.createApply((String)"ln1p", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "log10": {
                return PMMLUtil.createApply((String)"log10", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "negative": {
                return PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)-1), FunctionUtil.getOnlyElement(expressions)});
            }
            case "power": {
                return PMMLUtil.createApply((String)"pow", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 2, 0), FunctionUtil.getElement(expressions, 2, 1)});
            }
            case "radians": 
            case "deg2rad": {
                return PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), PMMLUtil.createConstant((Number)(Math.PI / 180))});
            }
            case "reciprocal": {
                return PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)1), FunctionUtil.getOnlyElement(expressions)});
            }
            case "rint": {
                return PMMLUtil.createApply((String)"rint", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "sign": {
                return PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"lessThan", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), PMMLUtil.createConstant((Number)0)}), PMMLUtil.createConstant((Number)-1), PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"greaterThan", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), PMMLUtil.createConstant((Number)0)}), PMMLUtil.createConstant((Number)1), PMMLUtil.createConstant((Number)0)})});
            }
            case "sin": {
                return PMMLUtil.createApply((String)"sin", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "sinh": {
                return PMMLUtil.createApply((String)"sinh", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "sqrt": {
                return PMMLUtil.createApply((String)"sqrt", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "square": {
                return PMMLUtil.createApply((String)"pow", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), PMMLUtil.createConstant((Number)2)});
            }
            case "tan": {
                return PMMLUtil.createApply((String)"tan", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
            case "tanh": {
                return PMMLUtil.createApply((String)"tanh", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
            }
        }
        throw new IllegalArgumentException(name);
    }

    private static Expression getOnlyElement(List<Expression> expressions) {
        return FunctionUtil.getElement(expressions, 1, 0);
    }

    private static Expression getElement(List<Expression> expressions, int expectedSize, int index) {
        if (expressions.size() != expectedSize) {
            throw new IllegalArgumentException();
        }
        return expressions.get(index);
    }
}

