/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.ArrayList;
import java.util.List;
import numpy.core.FunctionUtil;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.visitors.ExpressionCompactor;
import org.jpmml.python.AbstractTranslator;
import org.jpmml.python.ExpressionTranslatorConstants;
import org.jpmml.python.ExpressionTranslatorTokenManager;
import org.jpmml.python.ExpressionUtil;
import org.jpmml.python.ParseException;
import org.jpmml.python.Provider;
import org.jpmml.python.Scope;
import org.jpmml.python.SimpleCharStream;
import org.jpmml.python.StringProvider;
import org.jpmml.python.Token;
import org.jpmml.python.TokenMgrException;

public class ExpressionTranslator
extends AbstractTranslator
implements ExpressionTranslatorConstants {
    public ExpressionTranslatorTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[31];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[7];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    public static Expression translate(String string, Scope scope) {
        return ExpressionTranslator.translate(string, scope, true);
    }

    public static Expression translate(String string, Scope scope, boolean compact) {
        Expression expression;
        try {
            ExpressionTranslator expressionTranslator = new ExpressionTranslator(string);
            expressionTranslator.setScope(scope);
            expression = expressionTranslator.translateExpressionInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Python expression '" + string + "' is either invalid or not supported", pe);
        }
        if (compact) {
            ExpressionCompactor compactor = new ExpressionCompactor();
            compactor.applyTo((Visitable)expression);
        }
        return expression;
    }

    private static String translateRelationalOperator(Token operator) {
        switch (operator.kind) {
            case 12: {
                return "equal";
            }
            case 13: {
                return "notEqual";
            }
            case 14: {
                return "lessThan";
            }
            case 15: {
                return "lessOrEqual";
            }
            case 16: {
                return "greaterThan";
            }
            case 17: {
                return "greaterOrEqual";
            }
        }
        throw new IllegalArgumentException(operator.image);
    }

    private static String translateArithmeticOperator(Token operator) {
        switch (operator.kind) {
            case 22: {
                return "modulo";
            }
        }
        return operator.image;
    }

    private static Expression translateTrailerFunction(Expression expression, String function, List<Expression> arguments) {
        if ("lower".equals(function) || "upper".equals(function)) {
            if (arguments.size() != 0) {
                throw new IllegalArgumentException();
            }
            switch (function) {
                case "lower": {
                    return PMMLUtil.createApply((String)"lowercase", (Expression[])new Expression[]{expression});
                }
                case "upper": {
                    return PMMLUtil.createApply((String)"uppercase", (Expression[])new Expression[]{expression});
                }
            }
        } else if ("strip".equals(function)) {
            if (arguments.size() != 0) {
                throw new IllegalArgumentException();
            }
            return PMMLUtil.createApply((String)"trimBlanks", (Expression[])new Expression[]{expression});
        }
        throw new IllegalArgumentException(function);
    }

    private static Expression translateFunction(String function, List<Expression> arguments) {
        String name;
        String module;
        int dot = function.lastIndexOf(46);
        if (dot > -1) {
            module = function.substring(0, dot);
            name = function.substring(dot + 1);
        } else {
            module = "";
            name = function;
        }
        if ("".equals(module)) {
            if (arguments.size() != 1) {
                throw new IllegalArgumentException();
            }
            switch (name) {
                case "len": {
                    return PMMLUtil.createApply((String)"stringLength", (Expression[])new Expression[]{arguments.get(0)});
                }
            }
        } else if ("pandas".equals(module) || "pd".equals(module)) {
            if (arguments.size() != 1) {
                throw new IllegalArgumentException();
            }
            switch (name) {
                case "isnull": {
                    return PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{arguments.get(0)});
                }
                case "notnull": {
                    return PMMLUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{arguments.get(0)});
                }
            }
        } else if ("numpy".equals(module) || "np".equals(module)) {
            return FunctionUtil.encodeFunction("numpy", name, arguments);
        }
        throw new IllegalArgumentException(function);
    }

    private static String translateValue(Token value) {
        String image = value.image;
        switch (value.kind) {
            case 28: 
            case 30: {
                image = image.toLowerCase();
                break;
            }
            case 31: {
                if (!image.endsWith("l") && !image.endsWith("L")) break;
                image = image.substring(0, image.length() - 1);
                break;
            }
            case 34: {
                image = image.substring(1, image.length() - 1);
                break;
            }
        }
        return image;
    }

    private static int parseNonNegativeInt(String string) {
        int value = Integer.parseInt(string);
        if (value < 0) {
            throw new IllegalArgumentException(string);
        }
        return value;
    }

    private final Expression translateExpressionInternal() throws ParseException {
        Expression expression = this.Expression();
        this.jj_consume_token(0);
        return expression;
    }

    public final Expression Expression() throws ParseException {
        Expression expression = this.IfElseExpression();
        return expression;
    }

    public final Expression IfElseExpression() throws ParseException {
        Expression left = this.LogicalOrExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                Expression center = this.LogicalOrExpression();
                this.jj_consume_token(6);
                Expression right = this.LogicalOrExpression();
                left = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{center, left, right});
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        return left;
    }

    public final Expression LogicalOrExpression() throws ParseException {
        Expression left = this.LogicalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            Expression right = this.LogicalAndExpression();
            left = PMMLUtil.createApply((String)"or", (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    public final Expression LogicalAndExpression() throws ParseException {
        Expression left = this.NegationExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(8);
            Expression right = this.NegationExpression();
            left = PMMLUtil.createApply((String)"and", (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    public final Expression NegationExpression() throws ParseException {
        Token operator = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                operator = this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        Expression expression = this.ComparisonExpression();
        if (operator != null) {
            return PMMLUtil.createApply((String)"not", (Expression[])new Expression[]{expression});
        }
        return expression;
    }

    public final Expression ComparisonExpression() throws ParseException {
        Expression left;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            left = this.AdditiveExpression();
            this.jj_consume_token(10);
            this.jj_consume_token(29);
            left = PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{left});
        } else if (this.jj_2_2(Integer.MAX_VALUE)) {
            left = this.AdditiveExpression();
            this.jj_consume_token(10);
            this.jj_consume_token(9);
            this.jj_consume_token(29);
            left = PMMLUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{left});
        } else if (this.jj_2_3(Integer.MAX_VALUE)) {
            left = this.AdditiveExpression();
            this.jj_consume_token(11);
            Expression[] right = this.ListMakerExpression();
            left = PMMLUtil.createApply((String)"isIn", (Expression[])new Expression[]{left}).addExpressions(right);
        } else if (this.jj_2_4(Integer.MAX_VALUE)) {
            left = this.AdditiveExpression();
            this.jj_consume_token(9);
            this.jj_consume_token(11);
            Expression[] right = this.ListMakerExpression();
            left = PMMLUtil.createApply((String)"isNotIn", (Expression[])new Expression[]{left}).addExpressions(right);
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: 
                case 18: 
                case 19: 
                case 28: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    left = this.AdditiveExpression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: {
                            Token operator;
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 12: {
                                    operator = this.jj_consume_token(12);
                                    break;
                                }
                                case 13: {
                                    operator = this.jj_consume_token(13);
                                    break;
                                }
                                case 14: {
                                    operator = this.jj_consume_token(14);
                                    break;
                                }
                                case 15: {
                                    operator = this.jj_consume_token(15);
                                    break;
                                }
                                case 16: {
                                    operator = this.jj_consume_token(16);
                                    break;
                                }
                                case 17: {
                                    operator = this.jj_consume_token(17);
                                    break;
                                }
                                default: {
                                    this.jj_la1[4] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            Expression right = this.AdditiveExpression();
                            left = PMMLUtil.createApply((String)ExpressionTranslator.translateRelationalOperator(operator), (Expression[])new Expression[]{left, right});
                            break block0;
                        }
                    }
                    this.jj_la1[5] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return left;
    }

    public final Expression AdditiveExpression() throws ParseException {
        Expression left = this.MultiplicativeExpression();
        block7: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: {
                    operator = this.jj_consume_token(18);
                    break;
                }
                case 19: {
                    operator = this.jj_consume_token(19);
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.MultiplicativeExpression();
            Scope scope = this.ensureScope();
            if (operator.kind == 18 && ExpressionUtil.isString(left, scope) && ExpressionUtil.isString(right, scope)) {
                left = PMMLUtil.createApply((String)"concat", (Expression[])new Expression[]{left, right});
                continue;
            }
            left = PMMLUtil.createApply((String)ExpressionTranslator.translateArithmeticOperator(operator), (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    public final Expression MultiplicativeExpression() throws ParseException {
        Expression left = this.UnaryExpression();
        block8: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 20: {
                    operator = this.jj_consume_token(20);
                    break;
                }
                case 21: {
                    operator = this.jj_consume_token(21);
                    break;
                }
                case 22: {
                    operator = this.jj_consume_token(22);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.UnaryExpression();
            left = PMMLUtil.createApply((String)ExpressionTranslator.translateArithmeticOperator(operator), (Expression[])new Expression[]{left, right});
        }
        return left;
    }

    public final Expression UnaryExpression() throws ParseException {
        Expression expression;
        Token sign = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: {
                sign = this.jj_consume_token(18);
                expression = this.UnaryExpression();
                break;
            }
            case 19: {
                sign = this.jj_consume_token(19);
                expression = this.UnaryExpression();
                break;
            }
            case 3: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                expression = this.PrimaryExpression();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (sign != null && sign.kind == 19) {
            expression = PMMLUtil.toNegative((Expression)expression);
        }
        return expression;
    }

    public final Expression PrimaryExpression() throws ParseException {
        Expression expression;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                String featureOrFunction = this.DottedName();
                if (this.jj_2_5(Integer.MAX_VALUE)) {
                    expression = this.ArrayIndexingExpression(featureOrFunction);
                    block39: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 23: 
                            case 26: {
                                break;
                            }
                            default: {
                                this.jj_la1[12] = this.jj_gen;
                                break block0;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 26: {
                                expression = this.TrailerFunctionInvocationExpression(expression);
                                continue block39;
                            }
                            case 23: {
                                expression = this.StringSlicingExpression(expression);
                                continue block39;
                            }
                        }
                        break;
                    }
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: {
                        expression = this.FunctionInvocationExpression(featureOrFunction);
                        block40: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 23: 
                                case 26: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[14] = this.jj_gen;
                                    break block0;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 26: {
                                    expression = this.TrailerFunctionInvocationExpression(expression);
                                    continue block40;
                                }
                                case 23: {
                                    expression = this.StringSlicingExpression(expression);
                                    continue block40;
                                }
                            }
                            break;
                        }
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[19] = this.jj_gen;
                expression = this.NameInvocationExpression(featureOrFunction);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 23: {
                        expression = this.StringSlicingExpression(expression);
                        block41: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 23: 
                                case 26: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[16] = this.jj_gen;
                                    break block0;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 26: {
                                    expression = this.TrailerFunctionInvocationExpression(expression);
                                    continue block41;
                                }
                                case 23: {
                                    expression = this.StringSlicingExpression(expression);
                                    continue block41;
                                }
                            }
                            break;
                        }
                        this.jj_la1[17] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                break;
            }
            case 3: {
                expression = this.ParenthesizedExpression();
                block42: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 23: 
                        case 26: {
                            break;
                        }
                        default: {
                            this.jj_la1[20] = this.jj_gen;
                            break block0;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 26: {
                            expression = this.TrailerFunctionInvocationExpression(expression);
                            continue block42;
                        }
                        case 23: {
                            expression = this.StringSlicingExpression(expression);
                            continue block42;
                        }
                    }
                    break;
                }
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                expression = this.LiteralExpression();
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final String DottedName() throws ParseException {
        StringBuilder sb = new StringBuilder();
        Token name = this.jj_consume_token(33);
        sb.append(name.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 26: {
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(26);
            name = this.jj_consume_token(33);
            sb.append('.').append(name.image);
        }
        return sb.toString();
    }

    public final FieldRef ArrayIndexingExpression(String dottedName) throws ParseException {
        Token column;
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            this.jj_consume_token(23);
            column = this.jj_consume_token(31);
            this.jj_consume_token(24);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 23: {
                    this.jj_consume_token(23);
                    column = this.jj_consume_token(34);
                    this.jj_consume_token(24);
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        Scope scope = this.ensureScope();
        Feature feature = null;
        switch (column.kind) {
            case 31: {
                int colIndex = ExpressionTranslator.parseNonNegativeInt(column.image);
                feature = scope.getFeature(FieldName.create((String)dottedName), colIndex);
                break;
            }
            case 34: {
                String colName = column.image.substring(1, column.image.length() - 1);
                feature = scope.getFeature(FieldName.create((String)dottedName), FieldName.create((String)colName));
                break;
            }
        }
        return feature.ref();
    }

    public final Expression FunctionInvocationExpression(String dottedName) throws ParseException {
        List<Expression> arguments = this.Arguments();
        Scope scope = this.ensureScope();
        int dot = dottedName.lastIndexOf(46);
        if (dot > -1) {
            String featureName = dottedName.substring(0, dot);
            String functionName = dottedName.substring(dot + 1);
            Feature feature = scope.resolveFeature(FieldName.create((String)featureName));
            if (feature != null) {
                return ExpressionTranslator.translateTrailerFunction((Expression)feature.ref(), functionName, arguments);
            }
        }
        return ExpressionTranslator.translateFunction(dottedName, arguments);
    }

    public final Expression TrailerFunctionInvocationExpression(Expression expression) throws ParseException {
        this.jj_consume_token(26);
        Token name = this.jj_consume_token(33);
        List<Expression> arguments = this.Arguments();
        return ExpressionTranslator.translateTrailerFunction(expression, name.image, arguments);
    }

    public final List<Expression> Arguments() throws ParseException {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (this.jj_2_7(Integer.MAX_VALUE)) {
            this.jj_consume_token(3);
            this.jj_consume_token(4);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    Expression expression = this.Expression();
                    expressions.add(expression);
                    block6: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 25: {
                                break;
                            }
                            default: {
                                this.jj_la1[25] = this.jj_gen;
                                break block6;
                            }
                        }
                        this.jj_consume_token(25);
                        expression = this.Expression();
                        expressions.add(expression);
                    }
                    this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expressions;
    }

    public final Expression StringSlicingExpression(Expression expression) throws ParseException {
        Token start = null;
        Token stop = null;
        this.jj_consume_token(23);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 31: {
                start = this.jj_consume_token(31);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        this.jj_consume_token(27);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 31: {
                stop = this.jj_consume_token(31);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        this.jj_consume_token(24);
        if (start == null && stop == null) {
            return expression;
        }
        int offset = 0;
        int length = Integer.MAX_VALUE;
        if (start != null) {
            offset = ExpressionTranslator.parseNonNegativeInt(start.image);
        }
        if (stop != null) {
            length = ExpressionTranslator.parseNonNegativeInt(stop.image) - offset;
        }
        return PMMLUtil.createApply((String)"substring", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)(offset + 1), (DataType)DataType.INTEGER), PMMLUtil.createConstant((Object)length, (DataType)DataType.INTEGER)});
    }

    public final FieldRef NameInvocationExpression(String dottedName) throws ParseException {
        Scope scope = this.ensureScope();
        Feature feature = scope.getFeature(FieldName.create((String)dottedName));
        return feature.ref();
    }

    public final Expression ParenthesizedExpression() throws ParseException {
        this.jj_consume_token(3);
        Expression expression = this.Expression();
        this.jj_consume_token(4);
        return expression;
    }

    public final Constant LiteralExpression() throws ParseException {
        DataType dataType;
        Token value;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: {
                value = this.jj_consume_token(28);
                dataType = DataType.BOOLEAN;
                break;
            }
            case 30: {
                value = this.jj_consume_token(30);
                dataType = DataType.BOOLEAN;
                break;
            }
            case 31: {
                value = this.jj_consume_token(31);
                dataType = DataType.INTEGER;
                break;
            }
            case 32: {
                value = this.jj_consume_token(32);
                dataType = DataType.DOUBLE;
                break;
            }
            case 34: {
                value = this.jj_consume_token(34);
                dataType = DataType.STRING;
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Constant constant = new Constant().setValue((Object)ExpressionTranslator.translateValue(value)).setDataType(dataType);
        return constant;
    }

    public final Expression[] ListMakerExpression() throws ParseException {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        this.jj_consume_token(23);
        Expression expression = this.Expression();
        expressions.add(expression);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(25);
            expression = this.Expression();
            expressions.add(expression);
        }
        this.jj_consume_token(24);
        return expressions.toArray(new Expression[expressions.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    private boolean jj_3R_IfElseExpression_371_9_55() {
        if (this.jj_3R_LogicalOrExpression_384_9_61()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_IfElseExpression_371_40_62()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_ArrayIndexingExpression_555_9_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ArrayIndexingExpression_556_17_46()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_ArrayIndexingExpression_559_17_47()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_Expression_357_9_38() {
        return this.jj_3R_IfElseExpression_371_9_55();
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(31)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(34)) {
                return true;
            }
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_DottedName_543_9_24() {
        Token xsp;
        if (this.jj_scan_token(33)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_DottedName_543_52_31());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_ListMakerExpression_732_9_74() {
        Token xsp;
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_3R_Expression_357_9_38()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_ListMakerExpression_732_81_76());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_PrimaryExpression_524_25_27() {
        if (this.jj_3R_NameInvocationExpression_678_9_36()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_524_84_37()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_522_25_26() {
        Token xsp;
        if (this.jj_3R_FunctionInvocationExpression_595_9_34()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_PrimaryExpression_522_88_35());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_PrimaryExpression_529_17_23() {
        return this.jj_3R_LiteralExpression_705_9_30();
    }

    private boolean jj_3R_PrimaryExpression_519_25_25() {
        Token xsp;
        if (this.jj_3R_ArrayIndexingExpression_555_9_32()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_PrimaryExpression_520_83_33());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_PrimaryExpression_527_17_22() {
        Token xsp;
        if (this.jj_3R_ParenthesizedExpression_692_9_28()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_PrimaryExpression_527_58_29());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_LiteralExpression_714_17_45() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_LiteralExpression_712_17_44() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_LiteralExpression_710_17_43() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_PrimaryExpression_517_17_21() {
        if (this.jj_3R_DottedName_543_9_24()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_519_25_25()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_522_25_26()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_PrimaryExpression_524_25_27()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_LiteralExpression_708_17_42() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_Arguments_638_87_63() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_Expression_357_9_38();
    }

    private boolean jj_3R_LiteralExpression_706_17_41() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_PrimaryExpression_524_198_60() {
        return this.jj_3R_StringSlicingExpression_652_9_53();
    }

    private boolean jj_3R_PrimaryExpression_516_9_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_517_17_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_527_17_22()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_PrimaryExpression_529_17_23()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_LiteralExpression_705_9_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_LiteralExpression_706_17_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_LiteralExpression_708_17_42()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_LiteralExpression_710_17_43()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_LiteralExpression_712_17_44()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_LiteralExpression_714_17_45()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_MultiplicativeExpression_480_35_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(20)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(21)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(22)) {
                    return true;
                }
            }
        }
        return this.jj_3R_UnaryExpression_493_9_15();
    }

    private boolean jj_3R_UnaryExpression_498_17_19() {
        return this.jj_3R_PrimaryExpression_516_9_20();
    }

    private boolean jj_3R_UnaryExpression_496_17_18() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_UnaryExpression_493_9_15();
    }

    private boolean jj_3R_UnaryExpression_494_17_17() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_UnaryExpression_493_9_15();
    }

    private boolean jj_3R_ParenthesizedExpression_692_9_28() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_Expression_357_9_38()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_UnaryExpression_493_9_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_UnaryExpression_494_17_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_UnaryExpression_496_17_18()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_UnaryExpression_498_17_19()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_AdditiveExpression_456_44_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(18)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(19)) {
                return true;
            }
        }
        return this.jj_3R_MultiplicativeExpression_480_9_13();
    }

    private boolean jj_3R_NameInvocationExpression_678_9_36() {
        return false;
    }

    private boolean jj_3R_MultiplicativeExpression_480_9_13() {
        Token xsp;
        if (this.jj_3R_UnaryExpression_493_9_15()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_MultiplicativeExpression_480_35_16());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_ComparisonExpression_441_46_75() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(14)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(15)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(16)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(17)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_AdditiveExpression_456_9_12();
    }

    private boolean jj_3R_PrimaryExpression_522_151_52() {
        return this.jj_3R_StringSlicingExpression_652_9_53();
    }

    private boolean jj_3R_PrimaryExpression_520_146_49() {
        return this.jj_3R_StringSlicingExpression_652_9_53();
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_StringSlicingExpression_652_9_53() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(31)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(27)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(31)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_PrimaryExpression_524_135_54() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_524_135_59()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_524_198_60()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_524_135_59() {
        return this.jj_3R_TrailerFunctionInvocationExpression_621_9_56();
    }

    private boolean jj_3R_AdditiveExpression_456_9_12() {
        Token xsp;
        if (this.jj_3R_MultiplicativeExpression_480_9_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_AdditiveExpression_456_44_14());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_4() {
        if (this.jj_3R_AdditiveExpression_456_9_12()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_Arguments_638_17_58() {
        Token xsp;
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_3R_Expression_357_9_38()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_Arguments_638_87_63());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(4);
    }

    private boolean jj_3_3() {
        if (this.jj_3R_AdditiveExpression_456_9_12()) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_Arguments_635_17_57() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3_2() {
        if (this.jj_3R_AdditiveExpression_456_9_12()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_ComparisonExpression_441_17_73() {
        if (this.jj_3R_AdditiveExpression_456_9_12()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ComparisonExpression_441_46_75()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_527_121_40() {
        return this.jj_3R_StringSlicingExpression_652_9_53();
    }

    private boolean jj_3_1() {
        if (this.jj_3R_AdditiveExpression_456_9_12()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_ComparisonExpression_438_17_72() {
        if (this.jj_3R_AdditiveExpression_456_9_12()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_ListMakerExpression_732_9_74();
    }

    private boolean jj_3R_ComparisonExpression_435_17_71() {
        if (this.jj_3R_AdditiveExpression_456_9_12()) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_ListMakerExpression_732_9_74();
    }

    private boolean jj_3R_Arguments_634_9_50() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Arguments_635_17_57()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Arguments_638_17_58()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_ComparisonExpression_432_17_70() {
        if (this.jj_3R_AdditiveExpression_456_9_12()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_ComparisonExpression_429_17_69() {
        if (this.jj_3R_AdditiveExpression_456_9_12()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_TrailerFunctionInvocationExpression_621_9_56() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_3R_Arguments_634_9_50();
    }

    private boolean jj_3R_ComparisonExpression_428_9_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ComparisonExpression_429_17_69()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_ComparisonExpression_432_17_70()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_ComparisonExpression_435_17_71()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_ComparisonExpression_438_17_72()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_ComparisonExpression_441_17_73()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_LogicalAndExpression_397_39_67() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_NegationExpression_410_9_66();
    }

    private boolean jj_3R_ListMakerExpression_732_81_76() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_Expression_357_9_38();
    }

    private boolean jj_3R_LogicalOrExpression_384_41_65() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_LogicalAndExpression_397_9_64();
    }

    private boolean jj_3R_NegationExpression_410_9_66() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_ComparisonExpression_428_9_68();
    }

    private boolean jj_3R_PrimaryExpression_522_88_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_522_88_51()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_522_151_52()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_522_88_51() {
        return this.jj_3R_TrailerFunctionInvocationExpression_621_9_56();
    }

    private boolean jj_3R_PrimaryExpression_524_84_37() {
        Token xsp;
        if (this.jj_3R_StringSlicingExpression_652_9_53()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_PrimaryExpression_524_135_54());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_FunctionInvocationExpression_595_9_34() {
        return this.jj_3R_Arguments_634_9_50();
    }

    private boolean jj_3R_PrimaryExpression_520_83_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_520_83_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_520_146_49()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_PrimaryExpression_520_83_48() {
        return this.jj_3R_TrailerFunctionInvocationExpression_621_9_56();
    }

    private boolean jj_3R_IfElseExpression_371_40_62() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_LogicalOrExpression_384_9_61()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_LogicalOrExpression_384_9_61();
    }

    private boolean jj_3R_LogicalAndExpression_397_9_64() {
        Token xsp;
        if (this.jj_3R_NegationExpression_410_9_66()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_LogicalAndExpression_397_39_67());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_DottedName_543_52_31() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_PrimaryExpression_527_58_39() {
        return this.jj_3R_TrailerFunctionInvocationExpression_621_9_56();
    }

    private boolean jj_3R_PrimaryExpression_527_58_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_527_58_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_527_121_40()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_LogicalOrExpression_384_9_61() {
        Token xsp;
        if (this.jj_3R_LogicalAndExpression_397_9_64()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_LogicalOrExpression_384_41_65());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_ArrayIndexingExpression_559_17_47() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_ArrayIndexingExpression_556_17_46() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 128, 256, 512, 258048, 258048, -804519928, 786432, 786432, 0x700000, 0x700000, -804519928, 0x4800000, 0x4800000, 0x4800000, 0x4800000, 0x4800000, 0x4800000, 0x800000, 8, 0x4800000, 0x4800000, -805306360, 0x4000000, 0x800000, 0x2000000, 8, Integer.MIN_VALUE, Integer.MIN_VALUE, -805306368, 0x2000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 5, 0};
    }

    public ExpressionTranslator(Provider stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ExpressionTranslatorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ExpressionTranslatorTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionTranslator(ExpressionTranslatorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ExpressionTranslatorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[39];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 31; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 39; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : ExpressionTranslatorTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 7; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ExpressionTranslator.jj_la1_init_0();
        ExpressionTranslator.jj_la1_init_1();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

