/*
 * Decompiled with CFR 0.152.
 */
package pandas.core;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.HasArray;
import pandas.core.Index;
import pandas.core.Series;
import pandas.core.SingleBlockManager;

public class SeriesUtil {
    private SeriesUtil() {
    }

    public static <InK, OutK, InV, OutV> Map<OutK, OutV> toMap(Series series, Function<InK, OutK> keyFunction, Function<InV, OutV> valueFunction) {
        SingleBlockManager blockManager = series.getBlockManager();
        Index blockItem = blockManager.getOnlyBlockItem();
        List keys = Lists.transform(blockItem.getDataData(), keyFunction);
        HasArray blockValue = blockManager.getOnlyBlockValue();
        List values = Lists.transform(blockValue.getArrayContent(), valueFunction);
        ClassDictUtil.checkSize(keys, values);
        LinkedHashMap result = new LinkedHashMap();
        for (int i = 0; i < keys.size(); ++i) {
            result.put(keys.get(i), values.get(i));
        }
        return result;
    }
}

