/* ExpressionTranslator.java */
/* Generated By:JavaCC: Do not edit this line. ExpressionTranslator.java */
package org.jpmml.python;

import java.util.ArrayList;
import java.util.List;

import numpy.core.FunctionUtil;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.PMMLFunctions;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.visitors.ExpressionCompactor;

public class ExpressionTranslator extends AbstractTranslator implements ExpressionTranslatorConstants {

        static
        public Expression translate(String string, Scope scope){
                return translate(string, scope, true);
        }

        static
        public Expression translate(String string, Scope scope, boolean compact){
                Expression expression;

                try {
                        ExpressionTranslator expressionTranslator = new ExpressionTranslator(string);
                        expressionTranslator.setScope(scope);

                        expression = expressionTranslator.translateExpressionInternal();
                } catch(ParseException pe){
                        throw new IllegalArgumentException("Python expression \'" + string + "\' is either invalid or not supported", pe);
                }

                if(compact){
                        ExpressionCompactor compactor = new ExpressionCompactor();

                        compactor.applyTo(expression);
                }

                return expression;
        }

        static
        private String translateRelationalOperator(Token operator){

                switch(operator.kind){
                        case EQUAL:
                                return PMMLFunctions.EQUAL;
                        case NOT_EQUAL:
                                return PMMLFunctions.NOTEQUAL;
                        case LESS_THAN:
                                return PMMLFunctions.LESSTHAN;
                        case LESS_OR_EQUAL:
                                return PMMLFunctions.LESSOREQUAL;
                        case GREATER_THAN:
                                return PMMLFunctions.GREATERTHAN;
                        case GREATER_OR_EQUAL:
                                return PMMLFunctions.GREATEROREQUAL;
                        default:
                                throw new IllegalArgumentException(operator.image);
                }
        }

        static
        private String translateArithmeticOperator(Token operator){

                switch(operator.kind){
                        case MODULO:
                                return PMMLFunctions.MODULO;
                        default:
                                return operator.image;
                }
        }

        static
        private Constant translateConstant(String module, Token value){

                if(("numpy").equals(module) || ("np").equals(module)){

                        switch(value.kind){
                                case NAN:
                                        return PMMLUtil.createMissingConstant();
                                default:
                                        throw new IllegalArgumentException();
                        }
                }

                throw new IllegalArgumentException(module);
        }

        static
        private Expression translateTrailerFunction(Expression expression, String function, List<Expression> arguments){

                if(("startswith").equals(function) || ("endswith").equals(function)){

                        if(arguments.size() != 1){
                                throw new IllegalArgumentException();
                        }

                        Expression argument = arguments.get(0);
                        if(!(argument instanceof Constant)){
                                throw new IllegalArgumentException();
                        }

                        Constant constant = (Constant)argument;
                        if(!(DataType.STRING).equals(constant.getDataType())){
                                throw new IllegalArgumentException();
                        }

                        String value = (String)constant.getValue();

                        switch(function){
                                case "startswith":
                                        return PMMLUtil.createApply(PMMLFunctions.EQUAL,
                                                translateStringSlice(expression, 0, value.length()),
                                                constant
                                        );
                                case "endswith":
                                        return PMMLUtil.createApply(PMMLFunctions.EQUAL,
                                                translateStringSlice(expression, -value.length(), null),
                                                constant
                                        );
                                default:
                                        break;
                        }
                } else

                if(("lower").equals(function) || ("upper").equals(function)){

                        if(arguments.size() != 0){
                                throw new IllegalArgumentException();
                        }

                        switch(function){
                                case "lower":
                                        return PMMLUtil.createApply(PMMLFunctions.LOWERCASE, expression);
                                case "upper":
                                        return PMMLUtil.createApply(PMMLFunctions.UPPERCASE, expression);
                                default:
                                        break;
                        }
                } else

                if(("strip").equals(function)){

                        if(arguments.size() != 0){
                                throw new IllegalArgumentException();
                        }

                        return PMMLUtil.createApply(PMMLFunctions.TRIMBLANKS, expression);
                }

                throw new IllegalArgumentException(function);
        }

        static
        private Expression translateFunction(String function, List<Expression> arguments){
                String module;
                String name;

                int dot = function.lastIndexOf('.');
                if(dot > -1){
                        module = function.substring(0, dot);
                        name = function.substring(dot + 1);
                } else

                {
                        module = "";
                        name = function;
                }

                if(("").equals(module)){

                        if(arguments.size() != 1){
                                throw new IllegalArgumentException();
                        }

                        switch(name){
                                case "len":
                                        return PMMLUtil.createApply(PMMLFunctions.STRINGLENGTH, arguments.get(0));
                                default:
                                        break;
                        }
                } else

                if(("pandas").equals(module) || ("pd").equals(module)){

                        if(arguments.size() != 1){
                                throw new IllegalArgumentException();
                        }

                        switch(name){
                                case "isnull":
                                        return PMMLUtil.createApply(PMMLFunctions.ISMISSING, arguments.get(0));
                                case "notnull":
                                        return PMMLUtil.createApply(PMMLFunctions.ISNOTMISSING, arguments.get(0));
                                default:
                                        break;
                        }
                } else

                if(("numpy").equals(module) || ("np").equals(module)){
                        return FunctionUtil.encodeFunction("numpy", name, arguments);
                }

                throw new IllegalArgumentException(function);
        }

        static
        private Expression translateStringSlice(Expression expression, Integer startPos, Integer stopPos){

                if(startPos == null && stopPos == null){
                        return expression;
                }

                Expression offsetExpression;

                if(startPos != null && startPos >= 0){
                        offsetExpression = PMMLUtil.createConstant(startPos + 1, DataType.INTEGER);
                } else

                if(startPos != null && startPos < 0){
                        offsetExpression = PMMLUtil.createApply(PMMLFunctions.MAX,
                                PMMLUtil.createApply(PMMLFunctions.SUBTRACT,
                                        PMMLUtil.createApply(PMMLFunctions.STRINGLENGTH, expression),
                                        PMMLUtil.createConstant((-startPos) - 1, DataType.INTEGER)
                                ),
                                PMMLUtil.createConstant(1, DataType.INTEGER)
                        );
                } else

                {
                        offsetExpression = PMMLUtil.createConstant(1, DataType.INTEGER);
                } // End if

                Expression lengthExpression;

                if(stopPos != null && stopPos >= 0){

                        if(startPos != null && startPos >= 0){
                                lengthExpression = PMMLUtil.createConstant(Math.max(stopPos - startPos, 0), DataType.INTEGER);
                        } else

                        if(startPos != null && startPos < 0){
                                lengthExpression = PMMLUtil.createConstant(0, DataType.INTEGER);
                        } else

                        {
                                lengthExpression = PMMLUtil.createConstant(stopPos, DataType.INTEGER);
                        }
                } else

                if(stopPos != null && stopPos < 0){

                        if(startPos != null && startPos >= 0){
                                lengthExpression = PMMLUtil.createApply(PMMLFunctions.MAX,
                                        PMMLUtil.createApply(PMMLFunctions.SUBTRACT,
                                                PMMLUtil.createApply(PMMLFunctions.STRINGLENGTH, expression),
                                                PMMLUtil.createConstant(startPos + (-stopPos))
                                        ),
                                        PMMLUtil.createConstant(0, DataType.INTEGER)
                                );
                        } else

                        if(startPos != null && startPos < 0){
                                lengthExpression = PMMLUtil.createConstant(Math.max(stopPos - startPos, 0), DataType.INTEGER);
                        } else

                        {
                                lengthExpression = PMMLUtil.createApply(PMMLFunctions.MAX,
                                        PMMLUtil.createApply(PMMLFunctions.SUBTRACT,
                                                PMMLUtil.createApply(PMMLFunctions.STRINGLENGTH, expression),
                                                PMMLUtil.createConstant(-stopPos)
                                        ),
                                        PMMLUtil.createConstant(0, DataType.INTEGER)
                                );
                        }
                } else

                {
                        lengthExpression = PMMLUtil.createConstant(Integer.MAX_VALUE, DataType.INTEGER);
                }

                return PMMLUtil.createApply(PMMLFunctions.SUBSTRING, expression, offsetExpression, lengthExpression);
        }

        static
        private Object translateValue(Token value){
                String image = value.image;

                switch(value.kind){
                        case NONE:
                                return null;
                        case FALSE:
                        case TRUE:
                                return Boolean.valueOf(image.toLowerCase());
                        case INT:
                                if(image.endsWith("l") || image.endsWith("L")){
                                        image = image.substring(0, image.length() - 1);
                                }
                                return Integer.valueOf(image);
                        case FLOAT:
                                return Double.valueOf(image);
                        case STRING:
                                return image.substring(1, image.length() - 1);
                        default:
                                throw new IllegalArgumentException();
                }
        }

        static
        private int parseInt(Token sign, Token value){
                return Integer.parseInt(sign != null ? (sign.image + value.image) : value.image);
        }

  final private Expression translateExpressionInternal() throws ParseException {Expression expression;
    expression = Expression();
    jj_consume_token(0);
return expression;
}

  final public Expression Expression() throws ParseException {Expression expression;
    expression = IfElseExpression();
return expression;
}

  final public Expression IfElseExpression() throws ParseException {Expression left;
        Expression center;
        Expression right;
    left = LogicalOrExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      center = Expression();
      jj_consume_token(ELSE);
      right = Expression();
left = PMMLUtil.createApply(PMMLFunctions.IF, center, left, right);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
return left;
}

  final public Expression LogicalOrExpression() throws ParseException {Expression left;
        Expression right;
    left = LogicalAndExpression();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      jj_consume_token(OR);
      right = LogicalAndExpression();
left = PMMLUtil.createApply(PMMLFunctions.OR, left, right);
    }
return left;
}

  final public Expression LogicalAndExpression() throws ParseException {Expression left;
        Expression right;
    left = NegationExpression();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      jj_consume_token(AND);
      right = NegationExpression();
left = PMMLUtil.createApply(PMMLFunctions.AND, left, right);
    }
return left;
}

  final public Expression NegationExpression() throws ParseException {Token operator = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      operator = jj_consume_token(NOT);
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    expression = ComparisonExpression();
if(operator != null){
                        return PMMLUtil.createApply(PMMLFunctions.NOT, expression);
                }

                return expression;
}

  final public Expression ComparisonExpression() throws ParseException {Expression left;
        Token operator;
        Object right;
    if (jj_2_1(2147483647)) {
      left = AdditiveExpression();
      jj_consume_token(IS);
      jj_consume_token(NONE);
left = PMMLUtil.createApply(PMMLFunctions.ISMISSING, left);
    } else if (jj_2_2(2147483647)) {
      left = AdditiveExpression();
      jj_consume_token(IS);
      jj_consume_token(NOT);
      jj_consume_token(NONE);
left = PMMLUtil.createApply(PMMLFunctions.ISNOTMISSING, left);
    } else if (jj_2_3(2147483647)) {
      left = AdditiveExpression();
      jj_consume_token(IN);
      right = ListMakerExpression();
left = PMMLUtil.createApply(PMMLFunctions.ISIN, left).addExpressions((Expression[])right);
    } else if (jj_2_4(2147483647)) {
      left = AdditiveExpression();
      jj_consume_token(NOT);
      jj_consume_token(IN);
      right = ListMakerExpression();
left = PMMLUtil.createApply(PMMLFunctions.ISNOTIN, left).addExpressions((Expression[])right);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:
      case PLUS:
      case MINUS:
      case NONE:
      case FALSE:
      case TRUE:
      case INT:
      case FLOAT:
      case NAME:
      case STRING:{
        left = AdditiveExpression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQUAL:
        case NOT_EQUAL:
        case LESS_THAN:
        case LESS_OR_EQUAL:
        case GREATER_THAN:
        case GREATER_OR_EQUAL:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case EQUAL:{
            operator = jj_consume_token(EQUAL);
            break;
            }
          case NOT_EQUAL:{
            operator = jj_consume_token(NOT_EQUAL);
            break;
            }
          case LESS_THAN:{
            operator = jj_consume_token(LESS_THAN);
            break;
            }
          case LESS_OR_EQUAL:{
            operator = jj_consume_token(LESS_OR_EQUAL);
            break;
            }
          case GREATER_THAN:{
            operator = jj_consume_token(GREATER_THAN);
            break;
            }
          case GREATER_OR_EQUAL:{
            operator = jj_consume_token(GREATER_OR_EQUAL);
            break;
            }
          default:
            jj_la1[4] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          right = AdditiveExpression();
left = PMMLUtil.createApply(translateRelationalOperator(operator), left, (Expression)right);
          break;
          }
        default:
          jj_la1[5] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return left;
}

  final public Expression AdditiveExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = MultiplicativeExpression();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        operator = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        operator = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = MultiplicativeExpression();
Scope scope = ensureScope();

                if((operator.kind == PLUS) && (ExpressionUtil.isString(left, scope) && ExpressionUtil.isString(right, scope))){
                        left = PMMLUtil.createApply(PMMLFunctions.CONCAT, left, right);
                } else

                {
                        left = PMMLUtil.createApply(translateArithmeticOperator(operator), left, right);
                }
    }
return left;
}

  final public Expression MultiplicativeExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = UnaryExpression();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case MODULO:{
        ;
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:{
        operator = jj_consume_token(MULTIPLY);
        break;
        }
      case DIVIDE:{
        operator = jj_consume_token(DIVIDE);
        break;
        }
      case MODULO:{
        operator = jj_consume_token(MODULO);
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = UnaryExpression();
left = PMMLUtil.createApply(translateArithmeticOperator(operator), left, right);
    }
return left;
}

  final public Expression UnaryExpression() throws ParseException {Token sign = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:{
      sign = jj_consume_token(PLUS);
      expression = UnaryExpression();
      break;
      }
    case MINUS:{
      sign = jj_consume_token(MINUS);
      expression = UnaryExpression();
      break;
      }
    case LPAREN:
    case NONE:
    case FALSE:
    case TRUE:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:{
      expression = PrimaryExpression();
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if(sign != null && sign.kind == MINUS){
                        expression = PMMLUtil.toNegative(expression);
                }

                return expression;
}

  final public Expression PrimaryExpression() throws ParseException {String featureOrFunction;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      featureOrFunction = DottedName();
      if (jj_2_5(2147483647)) {
        expression = ArrayIndexingExpression(featureOrFunction);
        label_5:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LBRACKET:
          case DOT:{
            ;
            break;
            }
          default:
            jj_la1[12] = jj_gen;
            break label_5;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case DOT:{
            expression = TrailerFunctionInvocationExpression(expression);
            break;
            }
          case LBRACKET:{
            expression = StringSlicingExpression(expression);
            break;
            }
          default:
            jj_la1[13] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LPAREN:{
          expression = FunctionInvocationExpression(featureOrFunction);
          label_6:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case LBRACKET:
            case DOT:{
              ;
              break;
              }
            default:
              jj_la1[14] = jj_gen;
              break label_6;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case DOT:{
              expression = TrailerFunctionInvocationExpression(expression);
              break;
              }
            case LBRACKET:{
              expression = StringSlicingExpression(expression);
              break;
              }
            default:
              jj_la1[15] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        case DOT:{
          expression = ConstantExpression(featureOrFunction);
          break;
          }
        default:
          jj_la1[19] = jj_gen;
          expression = NameInvocationExpression(featureOrFunction);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LBRACKET:{
            expression = StringSlicingExpression(expression);
            label_7:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case LBRACKET:
              case DOT:{
                ;
                break;
                }
              default:
                jj_la1[16] = jj_gen;
                break label_7;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case DOT:{
                expression = TrailerFunctionInvocationExpression(expression);
                break;
                }
              case LBRACKET:{
                expression = StringSlicingExpression(expression);
                break;
                }
              default:
                jj_la1[17] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
            break;
            }
          default:
            jj_la1[18] = jj_gen;
            ;
          }
        }
      }
      break;
      }
    case LPAREN:{
      expression = ParenthesizedExpression();
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LBRACKET:
        case DOT:{
          ;
          break;
          }
        default:
          jj_la1[20] = jj_gen;
          break label_8;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DOT:{
          expression = TrailerFunctionInvocationExpression(expression);
          break;
          }
        case LBRACKET:{
          expression = StringSlicingExpression(expression);
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case NONE:
    case FALSE:
    case TRUE:
    case INT:
    case FLOAT:
    case STRING:{
      expression = LiteralExpression();
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return expression;
}

  final public String DottedName() throws ParseException {Token name;
        StringBuilder sb = new StringBuilder();
    name = jj_consume_token(NAME);
sb.append(name.image);
    label_9:
    while (true) {
      if (jj_2_6(2147483647)) {
        ;
      } else {
        break label_9;
      }
      jj_consume_token(DOT);
      name = jj_consume_token(NAME);
sb.append('.').append(name.image);
    }
return sb.toString();
}

  final public FieldRef ArrayIndexingExpression(String dottedName) throws ParseException {Token sign = null;
        Token column;
    if (jj_2_7(2147483647)) {
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        sign = Sign();
        break;
        }
      default:
        jj_la1[23] = jj_gen;
        ;
      }
      column = jj_consume_token(INT);
      jj_consume_token(RBRACKET);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        jj_consume_token(LBRACKET);
        column = jj_consume_token(STRING);
        jj_consume_token(RBRACKET);
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
Scope scope = ensureScope();

                Feature feature = null;

                switch(column.kind){
                        case INT:
                                {
                                        int colIndex = parseInt(sign, column);

                                        feature = scope.getFeature(FieldName.create(dottedName), colIndex);
                                }
                                break;
                        case STRING:
                                {
                                        String colName = column.image.substring(1, column.image.length() - 1);

                                        feature = scope.getFeature(FieldName.create(dottedName), FieldName.create(colName));
                                }
                                break;
                        default:
                                break;
                }

                return feature.ref();
}

  final public Token Sign() throws ParseException {Token token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:{
      token = jj_consume_token(PLUS);
      break;
      }
    case MINUS:{
      token = jj_consume_token(MINUS);
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return token;
}

  final public Expression FunctionInvocationExpression(String dottedName) throws ParseException {List<Expression> arguments;
    arguments = Arguments();
Scope scope = ensureScope();

                int dot = dottedName.lastIndexOf('.');
                if(dot > -1){
                        String featureName = dottedName.substring(0, dot);
                        String functionName = dottedName.substring(dot + 1);

                        Feature feature = scope.resolveFeature(FieldName.create(featureName));
                        if(feature != null){
                                return translateTrailerFunction(feature.ref(), functionName, arguments);
                        }
                }

                return translateFunction(dottedName, arguments);
}

  final public Expression TrailerFunctionInvocationExpression(Expression expression) throws ParseException {Token name;
        List<Expression> arguments;
    jj_consume_token(DOT);
    name = jj_consume_token(NAME);
    arguments = Arguments();
return translateTrailerFunction(expression, name.image, arguments);
}

  final public List<Expression> Arguments() throws ParseException {Expression expression;
        List<Expression> expressions = new ArrayList<Expression>();
    if (jj_2_8(2147483647)) {
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        expression = Expression();
expressions.add(expression);
        label_10:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[26] = jj_gen;
            break label_10;
          }
          jj_consume_token(COMMA);
          expression = Expression();
expressions.add(expression);
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return expressions;
}

  final public Expression StringSlicingExpression(Expression expression) throws ParseException {Token startSign = null;
        Token start = null;
        Token stopSign = null;
        Token stop = null;
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case INT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        startSign = Sign();
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        ;
      }
      start = jj_consume_token(INT);
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case INT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        stopSign = Sign();
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      stop = jj_consume_token(INT);
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
Integer startPos = null;
                if(start != null){
                        startPos = parseInt(startSign, start);
                }

                Integer stopPos = null;
                if(stop != null){
                        stopPos = parseInt(stopSign, stop);
                }

                return translateStringSlice(expression, startPos, stopPos);
}

  final public Constant ConstantExpression(String dottedName) throws ParseException {Token value;
    jj_consume_token(DOT);
    value = jj_consume_token(NAN);
return translateConstant(dottedName, value);
}

  final public FieldRef NameInvocationExpression(String dottedName) throws ParseException {
Scope scope = ensureScope();

                Feature feature = scope.getFeature(FieldName.create(dottedName));

                return feature.ref();
}

  final public Expression ParenthesizedExpression() throws ParseException {Expression expression;
    jj_consume_token(LPAREN);
    expression = Expression();
    jj_consume_token(RPAREN);
return expression;
}

  final public Constant LiteralExpression() throws ParseException {Token value;
        DataType dataType;
        Boolean missing = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NONE:{
      value = jj_consume_token(NONE);
dataType = null; missing = Boolean.TRUE;
      break;
      }
    case FALSE:{
      value = jj_consume_token(FALSE);
dataType = DataType.BOOLEAN;
      break;
      }
    case TRUE:{
      value = jj_consume_token(TRUE);
dataType = DataType.BOOLEAN;
      break;
      }
    case INT:{
      value = jj_consume_token(INT);
dataType = DataType.INTEGER;
      break;
      }
    case FLOAT:{
      value = jj_consume_token(FLOAT);
dataType = DataType.DOUBLE;
      break;
      }
    case STRING:{
      value = jj_consume_token(STRING);
dataType = DataType.STRING;
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
Constant constant = new Constant()
                        .setValue(translateValue(value))
                        .setDataType(dataType)
                        .setMissing(missing);

                return constant;
}

  final public Expression[] ListMakerExpression() throws ParseException {Expression expression;
        List<Expression> expressions = new ArrayList<Expression>();
    jj_consume_token(LBRACKET);
    expression = Expression();
expressions.add(expression);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        break label_11;
      }
      jj_consume_token(COMMA);
      expression = Expression();
expressions.add(expression);
    }
    jj_consume_token(RBRACKET);
return expressions.toArray(new Expression[expressions.size()]);
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_3R_FunctionInvocationExpression_753_9_40()
 {
    if (jj_3R_Arguments_792_9_56()) return true;
    return false;
  }

  private boolean jj_3R_LogicalOrExpression_523_41_75()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_LogicalAndExpression_536_9_74()) return true;
    return false;
  }

  private boolean jj_3R_NegationExpression_549_9_76()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_567_9_78()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_661_88_41()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_661_88_57()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_661_151_58()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_665_84_44()
 {
    if (jj_3R_StringSlicingExpression_812_9_59()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_665_135_60()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_661_88_57()
 {
    if (jj_3R_TrailerFunctionInvocationExpression_779_9_62()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_Sign_737_9_19()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_659_83_39()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_659_83_54()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_659_146_55()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_659_83_54()
 {
    if (jj_3R_TrailerFunctionInvocationExpression_779_9_62()) return true;
    return false;
  }

  private boolean jj_3R_IfElseExpression_510_40_70()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_3R_Expression_496_9_45()) return true;
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_Expression_496_9_45()) return true;
    return false;
  }

  private boolean jj_3R_null_698_39_14()
 {
    if (jj_3R_Sign_737_9_19()) return true;
    return false;
  }

  private boolean jj_3R_LogicalAndExpression_536_9_74()
 {
    if (jj_3R_NegationExpression_549_9_76()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_LogicalAndExpression_536_39_77()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_DottedName_684_52_38()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_699_29_22()
 {
    if (jj_3R_Sign_737_9_19()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_668_58_36()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_668_58_46()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_668_121_47()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_668_58_46()
 {
    if (jj_3R_TrailerFunctionInvocationExpression_779_9_62()) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_null_698_39_14()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_LogicalOrExpression_523_9_69()
 {
    if (jj_3R_LogicalAndExpression_536_9_74()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_LogicalOrExpression_523_41_75()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ListMakerExpression_903_9_84()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_Expression_496_9_45()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ListMakerExpression_903_81_86()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_701_17_18()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(STRING)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_698_17_17()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayIndexingExpression_699_29_22()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_IfElseExpression_510_9_61()
 {
    if (jj_3R_LogicalOrExpression_523_9_69()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IfElseExpression_510_40_70()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_LiteralExpression_884_17_53()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_LiteralExpression_882_17_52()
 {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_697_9_13()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayIndexingExpression_698_17_17()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayIndexingExpression_701_17_18()) return true;
    }
    return false;
  }

  private boolean jj_3R_LiteralExpression_880_17_51()
 {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_LiteralExpression_878_17_50()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_LiteralExpression_876_17_49()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_LiteralExpression_874_17_48()
 {
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_Expression_496_9_45()
 {
    if (jj_3R_IfElseExpression_510_9_61()) return true;
    return false;
  }

  private boolean jj_3R_DottedName_684_9_30()
 {
    if (jj_scan_token(NAME)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_DottedName_684_52_38()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_ArrayIndexingExpression_697_9_13()) return true;
    return false;
  }

  private boolean jj_3R_Arguments_796_87_71()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_Expression_496_9_45()) return true;
    return false;
  }

  private boolean jj_3R_LiteralExpression_873_9_37()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LiteralExpression_874_17_48()) {
    jj_scanpos = xsp;
    if (jj_3R_LiteralExpression_876_17_49()) {
    jj_scanpos = xsp;
    if (jj_3R_LiteralExpression_878_17_50()) {
    jj_scanpos = xsp;
    if (jj_3R_LiteralExpression_880_17_51()) {
    jj_scanpos = xsp;
    if (jj_3R_LiteralExpression_882_17_52()) {
    jj_scanpos = xsp;
    if (jj_3R_LiteralExpression_884_17_53()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_665_25_34()
 {
    if (jj_3R_NameInvocationExpression_845_9_43()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_665_84_44()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_StringSlicingExpression_812_69_73()
 {
    if (jj_3R_Sign_737_9_19()) return true;
    return false;
  }

  private boolean jj_3R_StringSlicingExpression_812_68_66()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_StringSlicingExpression_812_69_73()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_663_25_33()
 {
    if (jj_3R_ConstantExpression_834_9_42()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_670_17_29()
 {
    if (jj_3R_LiteralExpression_873_9_37()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_661_25_32()
 {
    if (jj_3R_FunctionInvocationExpression_753_9_40()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_661_88_41()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_668_17_28()
 {
    if (jj_3R_ParenthesizedExpression_859_9_35()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_668_58_36()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_658_25_31()
 {
    if (jj_3R_ArrayIndexingExpression_697_9_13()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_659_83_39()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ParenthesizedExpression_859_9_35()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_Expression_496_9_45()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_656_17_27()
 {
    if (jj_3R_DottedName_684_9_30()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_658_25_31()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_661_25_32()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_663_25_33()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_665_25_34()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_665_198_68()
 {
    if (jj_3R_StringSlicingExpression_812_9_59()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_655_9_26()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_656_17_27()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_668_17_28()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_670_17_29()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_NameInvocationExpression_845_9_43()
 {
    return false;
  }

  private boolean jj_3R_UnaryExpression_637_17_25()
 {
    if (jj_3R_PrimaryExpression_655_9_26()) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_619_35_21()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) return true;
    }
    }
    if (jj_3R_UnaryExpression_632_9_20()) return true;
    return false;
  }

  private boolean jj_3R_UnaryExpression_635_17_24()
 {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_UnaryExpression_632_9_20()) return true;
    return false;
  }

  private boolean jj_3R_ConstantExpression_834_9_42()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NAN)) return true;
    return false;
  }

  private boolean jj_3R_UnaryExpression_633_17_23()
 {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_UnaryExpression_632_9_20()) return true;
    return false;
  }

  private boolean jj_3R_StringSlicingExpression_812_22_72()
 {
    if (jj_3R_Sign_737_9_19()) return true;
    return false;
  }

  private boolean jj_3R_StringSlicingExpression_812_21_65()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_StringSlicingExpression_812_22_72()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_UnaryExpression_632_9_20()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnaryExpression_633_17_23()) {
    jj_scanpos = xsp;
    if (jj_3R_UnaryExpression_635_17_24()) {
    jj_scanpos = xsp;
    if (jj_3R_UnaryExpression_637_17_25()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_AdditiveExpression_595_44_16()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) return true;
    }
    if (jj_3R_MultiplicativeExpression_619_9_15()) return true;
    return false;
  }

  private boolean jj_3R_StringSlicingExpression_812_9_59()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_StringSlicingExpression_812_21_65()) jj_scanpos = xsp;
    if (jj_scan_token(COLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_StringSlicingExpression_812_68_66()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_619_9_15()
 {
    if (jj_3R_UnaryExpression_632_9_20()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_MultiplicativeExpression_619_35_21()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ComparisonExpression_580_46_85()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) return true;
    }
    }
    }
    }
    }
    if (jj_3R_AdditiveExpression_595_9_12()) return true;
    return false;
  }

  private boolean jj_3R_Arguments_796_17_64()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_Expression_496_9_45()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Arguments_796_87_71()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_661_151_58()
 {
    if (jj_3R_StringSlicingExpression_812_9_59()) return true;
    return false;
  }

  private boolean jj_3R_Arguments_793_17_63()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_659_146_55()
 {
    if (jj_3R_StringSlicingExpression_812_9_59()) return true;
    return false;
  }

  private boolean jj_3R_Arguments_792_9_56()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Arguments_793_17_63()) {
    jj_scanpos = xsp;
    if (jj_3R_Arguments_796_17_64()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_665_135_60()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_665_135_67()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_665_198_68()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_665_135_67()
 {
    if (jj_3R_TrailerFunctionInvocationExpression_779_9_62()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_AdditiveExpression_595_9_12()) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_595_9_12()
 {
    if (jj_3R_MultiplicativeExpression_619_9_15()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AdditiveExpression_595_44_16()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ListMakerExpression_903_81_86()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_Expression_496_9_45()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_AdditiveExpression_595_9_12()) return true;
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_AdditiveExpression_595_9_12()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_668_121_47()
 {
    if (jj_3R_StringSlicingExpression_812_9_59()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_580_17_83()
 {
    if (jj_3R_AdditiveExpression_595_9_12()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ComparisonExpression_580_46_85()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_TrailerFunctionInvocationExpression_779_9_62()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NAME)) return true;
    if (jj_3R_Arguments_792_9_56()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_AdditiveExpression_595_9_12()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_577_17_82()
 {
    if (jj_3R_AdditiveExpression_595_9_12()) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_ListMakerExpression_903_9_84()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_574_17_81()
 {
    if (jj_3R_AdditiveExpression_595_9_12()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_ListMakerExpression_903_9_84()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_571_17_80()
 {
    if (jj_3R_AdditiveExpression_595_9_12()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_568_17_79()
 {
    if (jj_3R_AdditiveExpression_595_9_12()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_567_9_78()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ComparisonExpression_568_17_79()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_571_17_80()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_574_17_81()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_577_17_82()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_580_17_83()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_LogicalAndExpression_536_39_77()
 {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_NegationExpression_549_9_76()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ExpressionTranslatorTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[34];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x20,0x80,0x100,0x200,0x3f000,0x3f000,0xe00c0008,0xc0000,0xc0000,0x700000,0x700000,0xe00c0008,0x9000000,0x9000000,0x9000000,0x9000000,0x9000000,0x9000000,0x1000000,0x8000008,0x9000000,0x9000000,0xe0000008,0xc0000,0x1000000,0xc0000,0x4000000,0x8,0xc0000,0xc0000,0xc0000,0xc0000,0xe0000000,0x4000000,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x1e,0x0,0x0,0x0,0x0,0x1e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x2,0x16,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[8];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public ExpressionTranslator(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new ExpressionTranslatorTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 34; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new ExpressionTranslatorTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 34; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ExpressionTranslator(ExpressionTranslatorTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 34; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ExpressionTranslatorTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 34; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[41];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 34; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 41; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : ExpressionTranslatorTokenManager.lexStateNames[token_source.curLexState]);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 8; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
