/* ExpressionTranslator.java */
/* Generated By:JavaCC: Do not edit this line. ExpressionTranslator.java */
package org.jpmml.python;

import java.util.ArrayList;
import java.util.List;

import numpy.core.UFuncUtil;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.PMMLFunctions;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.visitors.ExpressionCompactor;

public class ExpressionTranslator extends AbstractTranslator implements ExpressionTranslatorConstants {

        static
        public boolean isString(Expression expression, List<? extends Feature> features){

                if(expression instanceof Constant){
                        Constant constant = (Constant)expression;

                        return (DataType.STRING).equals(constant.getDataType());
                } else

                if(expression instanceof FieldRef){
                        FieldRef fieldRef = (FieldRef)expression;

                        Feature feature = getFeature(features, fieldRef.getField());

                        return (DataType.STRING).equals(feature.getDataType());
                } else

                if(expression instanceof Apply){
                        Apply apply = (Apply)expression;

                        String function = apply.getFunction();
                        switch(function){
                                case PMMLFunctions.CONCAT:
                                case PMMLFunctions.FORMATDATETIME:
                                case PMMLFunctions.FORMATNUMBER:
                                case PMMLFunctions.LOWERCASE:
                                case PMMLFunctions.REPLACE:
                                case PMMLFunctions.SUBSTRING:
                                case PMMLFunctions.TRIMBLANKS:
                                case PMMLFunctions.UPPERCASE:
                                        return true;
                                default:
                                        return false;
                        }
                }

                return false;
        }

        static
        public Expression translate(String string, List<? extends Feature> features){
                return translate(string, features, true);
        }

        static
        public Expression translate(String string, List<? extends Feature> features, boolean compact){
                Expression expression;

                try {
                        ExpressionTranslator expressionTranslator = new ExpressionTranslator(string);
                        expressionTranslator.setFeatures(features);

                        expression = expressionTranslator.translateExpressionInternal();
                } catch(ParseException pe){
                        throw new IllegalArgumentException("Python expression \'" + string + "\' is either invalid or not supported", pe);
                }

                if(compact){
                        ExpressionCompactor compactor = new ExpressionCompactor();

                        compactor.applyTo(expression);
                }

                return expression;
        }

        static
        private String translateRelationalOperator(Token operator){

                switch(operator.kind){
                        case EQUAL:
                                return PMMLFunctions.EQUAL;
                        case NOT_EQUAL:
                                return PMMLFunctions.NOTEQUAL;
                        case LESS_THAN:
                                return PMMLFunctions.LESSTHAN;
                        case LESS_OR_EQUAL:
                                return PMMLFunctions.LESSOREQUAL;
                        case GREATER_THAN:
                                return PMMLFunctions.GREATERTHAN;
                        case GREATER_OR_EQUAL:
                                return PMMLFunctions.GREATEROREQUAL;
                        default:
                                throw new IllegalArgumentException(operator.image);
                }
        }

        static
        private String translateArithmeticOperator(Token operator){

                switch(operator.kind){
                        case MODULO:
                                return PMMLFunctions.MODULO;
                        default:
                                return operator.image;
                }
        }

        static
        private Expression translateTrailerFunction(Expression expression, String function, List<Expression> arguments){

                if(("lower").equals(function) || ("upper").equals(function)){

                        if(arguments.size() != 0){
                                throw new IllegalArgumentException();
                        }

                        switch(function){
                                case "lower":
                                        return PMMLUtil.createApply(PMMLFunctions.LOWERCASE, expression);
                                case "upper":
                                        return PMMLUtil.createApply(PMMLFunctions.UPPERCASE, expression);
                                default:
                                        break;
                        }
                } else

                if(("strip").equals(function)){

                        if(arguments.size() != 0){
                                throw new IllegalArgumentException();
                        }

                        return PMMLUtil.createApply(PMMLFunctions.TRIMBLANKS, expression);
                }

                throw new IllegalArgumentException(function);
        }

        static
        private Expression translateFunction(String function, List<Expression> arguments){
                int dot = function.lastIndexOf('.');
                if(dot < 0){
                        throw new IllegalArgumentException(function);
                }

                String module = function.substring(0, dot);
                String name = function.substring(dot + 1);

                if(("pandas").equals(module) || ("pd").equals(module)){

                        if(arguments.size() != 1){
                                throw new IllegalArgumentException();
                        }

                        switch(name){
                                case "isnull":
                                        return PMMLUtil.createApply(PMMLFunctions.ISMISSING, arguments.get(0));
                                case "notnull":
                                        return PMMLUtil.createApply(PMMLFunctions.ISNOTMISSING, arguments.get(0));
                                default:
                                        break;
                        }
                } else

                if(("numpy").equals(module) || ("np").equals(module)){
                        return UFuncUtil.encodeUFunc("numpy", name, arguments);
                }

                throw new IllegalArgumentException(function);
        }

        static
        private String translateValue(Token value){
                String image = value.image;

                switch(value.kind){
                        case FALSE:
                        case TRUE:
                                image = image.toLowerCase();
                                break;
                        case INT:
                                if(image.endsWith("l") || image.endsWith("L")){
                                        image = image.substring(0, image.length() - 1);
                                }
                                break;
                        case STRING:
                                image = image.substring(1, image.length() - 1);
                                break;
                        default:
                                break;
                }

                return image;
        }

  final private Expression translateExpressionInternal() throws ParseException {Expression expression;
    expression = Expression();
    jj_consume_token(0);
return expression;
  }

  final public Expression Expression() throws ParseException {Expression expression;
    expression = IfElseExpression();
return expression;
  }

  final public Expression IfElseExpression() throws ParseException {Expression left;
        Expression center;
        Expression right;
    left = LogicalOrExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      center = LogicalOrExpression();
      jj_consume_token(ELSE);
      right = LogicalOrExpression();
left = PMMLUtil.createApply(PMMLFunctions.IF, center, left, right);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
return left;
  }

  final public Expression LogicalOrExpression() throws ParseException {Expression left;
        Expression right;
    left = LogicalAndExpression();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      jj_consume_token(OR);
      right = LogicalAndExpression();
left = PMMLUtil.createApply(PMMLFunctions.OR, left, right);
    }
return left;
  }

  final public Expression LogicalAndExpression() throws ParseException {Expression left;
        Expression right;
    left = NegationExpression();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      jj_consume_token(AND);
      right = NegationExpression();
left = PMMLUtil.createApply(PMMLFunctions.AND, left, right);
    }
return left;
  }

  final public Expression NegationExpression() throws ParseException {Token operator = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      operator = jj_consume_token(NOT);
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    expression = ComparisonExpression();
if(operator != null){
                        return PMMLUtil.createApply(PMMLFunctions.NOT, expression);
                }

                return expression;
  }

  final public Expression ComparisonExpression() throws ParseException {Expression left;
        Token operator;
        Object right;
    if (jj_2_1(2147483647)) {
      left = AdditiveExpression();
      jj_consume_token(IS);
      jj_consume_token(NONE);
left = PMMLUtil.createApply(PMMLFunctions.ISMISSING, left);
    } else if (jj_2_2(2147483647)) {
      left = AdditiveExpression();
      jj_consume_token(IS);
      jj_consume_token(NOT);
      jj_consume_token(NONE);
left = PMMLUtil.createApply(PMMLFunctions.ISNOTMISSING, left);
    } else if (jj_2_3(2147483647)) {
      left = AdditiveExpression();
      jj_consume_token(IN);
      right = ListMakerExpression();
left = PMMLUtil.createApply(PMMLFunctions.ISIN, left).addExpressions(((List<Expression>)right).toArray(new Expression[0]));
    } else if (jj_2_4(2147483647)) {
      left = AdditiveExpression();
      jj_consume_token(NOT);
      jj_consume_token(IN);
      right = ListMakerExpression();
left = PMMLUtil.createApply(PMMLFunctions.ISNOTIN, left).addExpressions(((List<Expression>)right).toArray(new Expression[0]));
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:
      case PLUS:
      case MINUS:
      case FALSE:
      case TRUE:
      case INT:
      case FLOAT:
      case NAME:
      case STRING:{
        left = AdditiveExpression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQUAL:
        case NOT_EQUAL:
        case LESS_THAN:
        case LESS_OR_EQUAL:
        case GREATER_THAN:
        case GREATER_OR_EQUAL:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case EQUAL:{
            operator = jj_consume_token(EQUAL);
            break;
            }
          case NOT_EQUAL:{
            operator = jj_consume_token(NOT_EQUAL);
            break;
            }
          case LESS_THAN:{
            operator = jj_consume_token(LESS_THAN);
            break;
            }
          case LESS_OR_EQUAL:{
            operator = jj_consume_token(LESS_OR_EQUAL);
            break;
            }
          case GREATER_THAN:{
            operator = jj_consume_token(GREATER_THAN);
            break;
            }
          case GREATER_OR_EQUAL:{
            operator = jj_consume_token(GREATER_OR_EQUAL);
            break;
            }
          default:
            jj_la1[4] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          right = AdditiveExpression();
left = PMMLUtil.createApply(translateRelationalOperator(operator), left, (Expression)right);
          break;
          }
        default:
          jj_la1[5] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return left;
  }

  final public Expression AdditiveExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = MultiplicativeExpression();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        operator = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        operator = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = MultiplicativeExpression();
List<? extends Feature> features = getFeatures();

                if((operator.kind == PLUS) && (isString(left, features) && isString(right, features))){
                        left = PMMLUtil.createApply(PMMLFunctions.CONCAT, left, right);
                } else

                {
                        left = PMMLUtil.createApply(translateArithmeticOperator(operator), left, right);
                }
    }
return left;
  }

  final public Expression MultiplicativeExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = UnaryExpression();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case MODULO:{
        ;
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:{
        operator = jj_consume_token(MULTIPLY);
        break;
        }
      case DIVIDE:{
        operator = jj_consume_token(DIVIDE);
        break;
        }
      case MODULO:{
        operator = jj_consume_token(MODULO);
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = UnaryExpression();
left = PMMLUtil.createApply(translateArithmeticOperator(operator), left, right);
    }
return left;
  }

  final public Expression UnaryExpression() throws ParseException {Token sign = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:{
      sign = jj_consume_token(PLUS);
      expression = UnaryExpression();
      break;
      }
    case MINUS:{
      sign = jj_consume_token(MINUS);
      expression = UnaryExpression();
      break;
      }
    case LPAREN:
    case FALSE:
    case TRUE:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:{
      expression = PrimaryExpression();
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if(sign != null && sign.kind == MINUS){
                        expression = PMMLUtil.toNegative(expression);
                }

                return expression;
  }

  final public Expression PrimaryExpression() throws ParseException {Expression expression;
        Token name = null;
        List<Expression> arguments = null;
    if (jj_2_5(2147483647)) {
      expression = ArrayIndexingExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        name = jj_consume_token(NAME);
        arguments = Arguments();
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NAME:{
        expression = FunctionInvocationExpression();
        break;
        }
      case LPAREN:{
        expression = ParenthesizedExpression();
        break;
        }
      case FALSE:
      case TRUE:
      case INT:
      case FLOAT:
      case STRING:{
        expression = LiteralExpression();
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
if(name != null){
                        return translateTrailerFunction(expression, name.image, arguments);
                }

                return expression;
  }

  final public FieldRef ArrayIndexingExpression() throws ParseException {Token name;
        Token column;
    if (jj_2_6(2147483647)) {
      name = jj_consume_token(NAME);
      jj_consume_token(LBRACKET);
      column = jj_consume_token(INT);
      jj_consume_token(RBRACKET);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NAME:{
        name = jj_consume_token(NAME);
        jj_consume_token(LBRACKET);
        column = jj_consume_token(STRING);
        jj_consume_token(RBRACKET);
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
List<? extends Feature> features = getFeatures();

                if(!("X").equals(name.image)){
                        {if (true) throw new IllegalArgumentException("Name \'" + name.image + "\' is not defined");}
                }

                Feature feature;

                switch(column.kind){
                        case ExpressionTranslatorConstants.INT:
                                {
                                        int colIndex = Integer.parseInt(column.image);

                                        feature = getFeature(features, colIndex);
                                }
                                break;
                        case ExpressionTranslatorConstants.STRING:
                                {
                                        String colName = column.image.substring(1, column.image.length() - 1);

                                        feature = getFeature(features, FieldName.create(colName));
                                }
                                break;
                        default:
                                {if (true) throw new IllegalArgumentException();}
                }

                return feature.ref();
  }

  final public Expression FunctionInvocationExpression() throws ParseException {Token name;
        List<Expression> arguments;
        StringBuilder function = new StringBuilder();
    name = jj_consume_token(NAME);
if(("X").equals(name.image)){
                        {if (true) throw new IllegalArgumentException("Name \'X\' refers to a row vector. Use an array indexing expression X[<column index>] or X[<column name>] to refer to a specific row vector element");}
                }

                function.append(name.image);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        ;
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        break label_5;
      }
      jj_consume_token(DOT);
      name = jj_consume_token(NAME);
function.append('.').append(name.image);
    }
    arguments = Arguments();
return translateFunction(function.toString(), arguments);
  }

  final public List<Expression> Arguments() throws ParseException {Expression expression;
        List<Expression> expressions = new ArrayList<Expression>();
    if (jj_2_7(2147483647)) {
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        expression = Expression();
expressions.add(expression);
        label_6:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[16] = jj_gen;
            break label_6;
          }
          jj_consume_token(COMMA);
          expression = Expression();
expressions.add(expression);
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return expressions;
  }

  final public Expression ParenthesizedExpression() throws ParseException {Expression expression;
    jj_consume_token(LPAREN);
    expression = Expression();
    jj_consume_token(RPAREN);
return expression;
  }

  final public Constant LiteralExpression() throws ParseException {Token value;
        DataType dataType;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FALSE:{
      value = jj_consume_token(FALSE);
dataType = DataType.BOOLEAN;
      break;
      }
    case TRUE:{
      value = jj_consume_token(TRUE);
dataType = DataType.BOOLEAN;
      break;
      }
    case INT:{
      value = jj_consume_token(INT);
dataType = DataType.INTEGER;
      break;
      }
    case FLOAT:{
      value = jj_consume_token(FLOAT);
dataType = DataType.DOUBLE;
      break;
      }
    case STRING:{
      value = jj_consume_token(STRING);
dataType = DataType.STRING;
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
Constant constant = new Constant()
                        .setValue(translateValue(value))
                        .setDataType(dataType);

                return constant;
  }

  final public List<Expression> ListMakerExpression() throws ParseException {Expression expression;
        List<Expression> expressions = new ArrayList<Expression>();
    jj_consume_token(LBRACKET);
    expression = Expression();
expressions.add(expression);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        break label_7;
      }
      jj_consume_token(COMMA);
      expression = Expression();
expressions.add(expression);
    }
    jj_consume_token(RBRACKET);
return expressions;
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_3R_26()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(INT)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_31()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_8()) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_8()
 {
    if (jj_3R_9()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_10()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_8()) return true;
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3R_30()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_8()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_3R_8()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_21()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) return true;
    }
    return false;
  }

  private boolean jj_3R_25()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_8()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_3R_8()) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    if (jj_3R_8()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    if (jj_3R_8()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_20()
 {
    if (jj_3R_25()) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_3R_8()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_19()
 {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_24()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_30()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_18()
 {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_17()
 {
    if (jj_3R_21()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_22()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_30()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_39()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_45()
 {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_36()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_16()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_28()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) return true;
    }
    return false;
  }

  private boolean jj_3R_43()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3R_15()
 {
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3R_12()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) return true;
    }
    }
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_44()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) jj_scanpos = xsp;
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3R_14()
 {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_29()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_13()
 {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_3R_40()) return true;
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_23()
 {
    if (jj_scan_token(NAME)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_29()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_11()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_13()) {
    jj_scanpos = xsp;
    if (jj_3R_14()) {
    jj_scanpos = xsp;
    if (jj_3R_15()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_3R_44()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_45()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_10()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) return true;
    }
    if (jj_3R_9()) return true;
    return false;
  }

  private boolean jj_3R_9()
 {
    if (jj_3R_11()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_12()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_3R_42()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_43()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_53()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) return true;
    }
    }
    }
    }
    }
    if (jj_3R_8()) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_30()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_54()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_22()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NAME)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_38()
 {
    if (jj_3R_40()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_35()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_34()
 {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_33()
 {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_27()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(STRING)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_32()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ExpressionTranslatorTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[20];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x20,0x80,0x100,0x200,0x3f000,0x3f000,0xe80c0008,0xc0000,0xc0000,0x700000,0x700000,0xe80c0008,0x4000000,0xe8000008,0x0,0x4000000,0x2000000,0x8,0xe8000000,0x2000000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x3,0x0,0x3,0x1,0x0,0x0,0x0,0x2,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public ExpressionTranslator(Provider stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ExpressionTranslatorTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 20; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
      this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
     ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
      jj_input_stream = new SimpleCharStream(stream, 1, 1);
   } else {
      jj_input_stream.ReInit(stream, 1, 1);
   }
   if (token_source == null) {
      token_source = new ExpressionTranslatorTokenManager(jj_input_stream);
   }

    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 20; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ExpressionTranslator(ExpressionTranslatorTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 20; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ExpressionTranslatorTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 20; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[38];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 20; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 38; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : ExpressionTranslatorTokenManager.lexStateNames[token_source.curLexState]);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 7; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
