/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import joblib.NDArrayWrapper;
import net.razorvine.pickle.objects.ClassDict;
import numpy.core.NDArray;
import numpy.core.NDArrayUtil;
import numpy.core.ScalarUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.CastFunction;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.HasArray;

public abstract class PythonObject
extends ClassDict {
    public PythonObject(String module, String name) {
        super(module, name);
    }

    public String getPythonModule() {
        String className = this.getClassName();
        int dot = className.lastIndexOf(46);
        if (dot > -1) {
            return className.substring(0, dot);
        }
        return null;
    }

    public String getPythonName() {
        String className = this.getClassName();
        int dot = className.lastIndexOf(46);
        if (dot > -1) {
            return className.substring(dot + 1);
        }
        return className;
    }

    public <E> E get(final String name, Class<? extends E> clazz) {
        Object value = this.get(name);
        if (value == null) {
            if (!this.containsKey(name)) {
                throw new IllegalArgumentException("Attribute '" + ClassDictUtil.formatMember(this, name) + "' not set");
            }
            throw new IllegalArgumentException("Attribute '" + ClassDictUtil.formatMember(this, name) + "' has a missing (None/null) value");
        }
        CastFunction castFunction = new CastFunction<E>(clazz){

            @Override
            protected String formatMessage(Object object) {
                return "Attribute '" + ClassDictUtil.formatMember(PythonObject.this, name) + "' has an unsupported value (" + ClassDictUtil.formatClass(object) + ")";
            }
        };
        return castFunction.apply(value);
    }

    public <E> E getOptional(String name, Class<? extends E> clazz) {
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        return this.get(name, clazz);
    }

    public Boolean getBoolean(String name) {
        return this.get(name, Boolean.class);
    }

    public Boolean getOptionalBoolean(String name, Boolean defaultValue) {
        Boolean value = this.getOptional(name, Boolean.class);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Integer getInteger(String name) {
        return ValueUtil.asInteger((Number)this.getNumber(name));
    }

    public Number getNumber(String name) {
        Object object = this.get(name, Object.class);
        object = ScalarUtil.decode(object);
        return (Number)object;
    }

    public Object getObject(String name) {
        return this.get(name, Object.class);
    }

    public Object getOptionalObject(String name) {
        return this.getOptional(name, Object.class);
    }

    public Object getScalar(String name) {
        Object object = this.get(name);
        return ScalarUtil.decode(object);
    }

    public Object getOptionalScalar(String name) {
        Object object = this.getOptional(name, Object.class);
        return ScalarUtil.decode(object);
    }

    public String getString(String name) {
        return this.get(name, String.class);
    }

    public String getOptionalString(String name) {
        return this.getOptional(name, String.class);
    }

    public Object[] getTuple(String name) {
        return this.get(name, Object[].class);
    }

    public List<?> getArray(String name) {
        Object object = this.get(name);
        if (object instanceof HasArray) {
            HasArray hasArray = (HasArray)object;
            return hasArray.getArrayContent();
        }
        if (object instanceof Number) {
            return Collections.singletonList(object);
        }
        throw new IllegalArgumentException("The value of '" + ClassDictUtil.formatMember(this, name) + "' attribute (" + ClassDictUtil.formatClass(object) + ") is not a supported array type");
    }

    public List<?> getArray(String name, String key) {
        Object object = this.get(name);
        if (object instanceof NDArrayWrapper) {
            NDArrayWrapper arrayWrapper = (NDArrayWrapper)object;
            object = arrayWrapper.getContent();
        }
        if (object instanceof NDArray) {
            NDArray array = (NDArray)object;
            return NDArrayUtil.getContent(array, key);
        }
        throw new IllegalArgumentException("The value of '" + ClassDictUtil.formatMember(this, name) + "' attribute (" + ClassDictUtil.formatClass(object) + ") is not a supported array type");
    }

    public List<Boolean> getBooleanArray(String name) {
        return this.getArray(name, Boolean.class);
    }

    public List<Integer> getIntegerArray(String name) {
        List<Number> values = this.getNumberArray(name);
        return ValueUtil.asIntegers(values);
    }

    public List<Number> getNumberArray(final String name) {
        List<?> values = this.getArray(name);
        CastFunction<Number> castFunction = new CastFunction<Number>(Number.class){

            @Override
            public Number apply(Object object) {
                return (Number)super.apply(ScalarUtil.decode(object));
            }

            @Override
            protected String formatMessage(Object object) {
                return "Array attribute '" + ClassDictUtil.formatMember(PythonObject.this, name) + "' contains an unsupported value (" + ClassDictUtil.formatClass(object) + ")";
            }
        };
        return Lists.transform(values, (Function)castFunction);
    }

    public <E> List<? extends E> getArray(final String name, Class<? extends E> clazz) {
        List<?> values = this.getArray(name);
        CastFunction castFunction = new CastFunction<E>(clazz){

            @Override
            protected String formatMessage(Object object) {
                return "Array attribute '" + ClassDictUtil.formatMember(PythonObject.this, name) + "' contains an unsupported value (" + ClassDictUtil.formatClass(object) + ")";
            }
        };
        return Lists.transform(values, (Function)castFunction);
    }

    public int[] getArrayShape(String name) {
        Object object = this.get(name);
        if (object instanceof HasArray) {
            HasArray hasArray = (HasArray)object;
            return hasArray.getArrayShape();
        }
        if (object instanceof Number) {
            return new int[]{1};
        }
        throw new IllegalArgumentException("The value of '" + ClassDictUtil.formatMember(this, name) + "' attribute (" + ClassDictUtil.formatClass(object) + ") is not a supported array type");
    }

    public int[] getArrayShape(String name, int length) {
        int[] shape = this.getArrayShape(name);
        if (shape.length != length) {
            throw new IllegalArgumentException("Expected " + length + "-dimensional array, got " + shape.length + "-dimensional (" + Arrays.toString(shape) + ") array");
        }
        return shape;
    }

    public List<?> getList(String name) {
        return this.get(name, List.class);
    }

    public <E> List<E> getList(final String name, Class<? extends E> clazz) {
        List<?> values = this.getList(name);
        CastFunction castFunction = new CastFunction<E>(clazz){

            @Override
            protected String formatMessage(Object object) {
                return "List attribute '" + ClassDictUtil.formatMember(PythonObject.this, name) + "' contains an unsupported value (" + ClassDictUtil.formatClass(object) + ")";
            }
        };
        return Lists.transform(values, (Function)castFunction);
    }

    public List<Object[]> getTupleList(String name) {
        return this.getList(name, Object[].class);
    }

    public List<?> getListLike(String name) {
        Object object = this.get(name);
        if (object instanceof HasArray) {
            return this.getArray(name);
        }
        return this.getList(name);
    }

    public <E> List<E> getListLike(final String name, Class<? extends E> clazz) {
        List<?> values = this.getListLike(name);
        CastFunction castFunction = new CastFunction<E>(clazz){

            @Override
            protected String formatMessage(Object object) {
                return "Array or list attribute '" + ClassDictUtil.formatMember(PythonObject.this, name) + "' contains an unsupported value (" + ClassDictUtil.formatClass(object) + ")";
            }
        };
        return Lists.transform(values, (Function)castFunction);
    }
}

