/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.Feature;
import org.jpmml.python.Scope;

public class DataFrameScope
extends Scope {
    private FieldName name = null;
    private List<? extends Feature> columns = null;

    public DataFrameScope(List<? extends Feature> features) {
        this(FieldName.create((String)"X"), features);
    }

    public DataFrameScope(FieldName name, List<? extends Feature> columns) {
        this.setName(name);
        this.setColumns(columns);
    }

    @Override
    public Feature getFeature(FieldName name) {
        FieldName dataFrameName = this.getName();
        this.checkName(name);
        throw new IllegalArgumentException("Name '" + dataFrameName.getValue() + "' refers to a row vector. Use an array indexing expression " + dataFrameName.getValue() + "[<column index>] or " + dataFrameName.getValue() + "[<column name>] to refer to a specific row vector element");
    }

    @Override
    public Feature getFeature(FieldName name, int columnIndex) {
        List<? extends Feature> features = this.getColumns();
        this.checkName(name);
        if (columnIndex >= 0 && columnIndex < features.size()) {
            return features.get(columnIndex);
        }
        throw new IllegalArgumentException("Column index " + columnIndex + " not in range " + Arrays.asList(0, features.size()));
    }

    @Override
    public Feature getFeature(FieldName name, FieldName columnName) {
        List<? extends Feature> features = this.getColumns();
        this.checkName(name);
        for (Feature feature2 : features) {
            if (!feature2.getName().equals((Object)columnName)) continue;
            return feature2;
        }
        List columnNames = features.stream().map(feature -> "'" + feature.getName().getValue() + "'").collect(Collectors.toList());
        throw new IllegalArgumentException("Column name '" + columnName.getValue() + "' is not in " + columnNames);
    }

    @Override
    public Feature resolveFeature(FieldName name) {
        List<? extends Feature> features = this.getColumns();
        for (Feature feature : features) {
            if (!feature.getName().equals((Object)name)) continue;
            return feature;
        }
        return null;
    }

    private void checkName(FieldName name) {
        FieldName dataFrameName = this.getName();
        if (!dataFrameName.equals((Object)name)) {
            throw new IllegalArgumentException("Name '" + name.getValue() + "' is not defined");
        }
    }

    public FieldName getName() {
        return this.name;
    }

    private void setName(FieldName name) {
        this.name = Objects.requireNonNull(name);
    }

    public List<? extends Feature> getColumns() {
        return this.columns;
    }

    private void setColumns(List<? extends Feature> columns) {
        this.columns = Objects.requireNonNull(columns);
    }
}

