/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.InflaterInputStream;
import org.jpmml.sklearn.InputStreamStorage;

public class CompressedInputStreamStorage
extends InputStreamStorage {
    public CompressedInputStreamStorage(InputStream is) throws IOException {
        super(CompressedInputStreamStorage.init(new PushbackInputStream(is, 2)));
    }

    private static InputStream init(PushbackInputStream is) throws IOException {
        byte[] magic = new byte[2];
        ByteStreams.readFully((InputStream)is, (byte[])magic);
        is.unread(magic);
        if (magic[0] == 120) {
            return CompressedInputStreamStorage.initZlib(is);
        }
        if (magic[0] == 90 && magic[1] == 70) {
            return CompressedInputStreamStorage.initCompat(is);
        }
        throw new IOException();
    }

    private static InputStream initZlib(PushbackInputStream is) {
        InflaterInputStream zlibIs = new InflaterInputStream(is);
        return zlibIs;
    }

    private static InputStream initCompat(PushbackInputStream is) throws IOException {
        byte[] headerBytes = new byte[21];
        ByteStreams.readFully((InputStream)is, (byte[])headerBytes);
        String header = new String(headerBytes);
        if (!header.startsWith("ZF0x")) {
            throw new IOException();
        }
        header = header.trim();
        final long expectedSize = Long.parseLong(header.substring(4), 16);
        int firstByte = is.read();
        if (firstByte < 0) {
            return is;
        }
        if (firstByte != 32) {
            is.unread(firstByte);
        }
        InflaterInputStream zlibIs = new InflaterInputStream(is);
        FilterInputStream result = new FilterInputStream((InputStream)new CountingInputStream((InputStream)zlibIs)){
            private boolean closed;
            {
                super(x0);
                this.closed = false;
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                long size = ((CountingInputStream)this.in).getCount();
                super.close();
                if (size != expectedSize) {
                    throw new IOException("Expected " + expectedSize + " bytes of uncompressed data, got " + size + " bytes");
                }
            }
        };
        return result;
    }
}

