/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.util.ArrayList;
import java.util.List;

public class MatrixUtil {
    private MatrixUtil() {
    }

    public static <E> List<E> getRow(List<E> values, int rows, int columns, int row) {
        if (values.size() != rows * columns) {
            throw new IllegalArgumentException();
        }
        int offset = row * columns;
        return values.subList(offset, offset + columns);
    }

    public static <E> List<E> getColumn(List<E> values, int rows, int columns, int column) {
        if (values.size() != rows * columns) {
            throw new IllegalArgumentException();
        }
        ArrayList<E> result = new ArrayList<E>(rows);
        for (int row = 0; row < rows; ++row) {
            E value = values.get(row * columns + column);
            result.add(value);
        }
        return result;
    }
}

