/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.ParameterField;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.FeatureMapper;
import sklearn.Classifier;
import sklearn.Estimator;
import sklearn.Regressor;

public class EstimatorUtil {
    private static final Function<Object, Classifier> classifierTransformer = new Function<Object, Classifier>(){

        public Classifier apply(Object object) {
            try {
                if (object == null) {
                    throw new NullPointerException();
                }
                return (Classifier)((Object)object);
            }
            catch (RuntimeException re) {
                throw new IllegalArgumentException("The estimator object (" + ClassDictUtil.formatClass(object) + ") is not a Classifier or is not a supported Classifier subclass", re);
            }
        }
    };
    private static final Function<Object, Regressor> regressorTransformer = new Function<Object, Regressor>(){

        public Regressor apply(Object object) {
            try {
                if (object == null) {
                    throw new NullPointerException();
                }
                return (Regressor)((Object)object);
            }
            catch (RuntimeException re) {
                throw new IllegalArgumentException("The estimator object (" + ClassDictUtil.formatClass(object) + ") is not a Regressor or is not a supported Regressor subclass", re);
            }
        }
    };

    private EstimatorUtil() {
    }

    public static PMML encodePMML(Estimator estimator, FeatureMapper featureMapper) {
        Schema schema = estimator.createSchema(featureMapper);
        Set<DefineFunction> defineFunctions = estimator.encodeDefineFunctions();
        for (DefineFunction defineFunction : defineFunctions) {
            featureMapper.addDefineFunction(defineFunction);
        }
        Model model = estimator.encodeModel(schema);
        PMML pmml = featureMapper.encodePMML(model);
        return pmml;
    }

    public static Classifier asClassifier(Object object) {
        return (Classifier)((Object)classifierTransformer.apply(object));
    }

    public static List<? extends Classifier> asClassifierList(List<?> objects) {
        return Lists.transform(objects, classifierTransformer);
    }

    public static Regressor asRegressor(Object object) {
        return (Regressor)((Object)regressorTransformer.apply(object));
    }

    public static List<? extends Regressor> asRegressorList(List<?> objects) {
        return Lists.transform(objects, regressorTransformer);
    }

    public static DefineFunction encodeLogitFunction() {
        return EstimatorUtil.encodeLossFunction("logit", -1.0);
    }

    public static DefineFunction encodeAdaBoostFunction() {
        return EstimatorUtil.encodeLossFunction("adaboost", -2.0);
    }

    private static DefineFunction encodeLossFunction(String function, double multiplier) {
        FieldName name = FieldName.create((String)"value");
        ParameterField parameterField = new ParameterField(name).setDataType(DataType.DOUBLE).setOpType(OpType.CONTINUOUS);
        Apply expression = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{PMMLUtil.createConstant((Object)1.0), PMMLUtil.createApply((String)"+", (Expression[])new Expression[]{PMMLUtil.createConstant((Object)1.0), PMMLUtil.createApply((String)"exp", (Expression[])new Expression[]{PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{PMMLUtil.createConstant((Object)multiplier), new FieldRef(name)})})})});
        DefineFunction defineFunction = new DefineFunction(function, OpType.CONTINUOUS, null).setDataType(DataType.DOUBLE).setOpType(OpType.CONTINUOUS).addParameterFields(new ParameterField[]{parameterField}).setExpression((Expression)expression);
        return defineFunction;
    }
}

