/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.bagging;

import java.util.List;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.MultipleModelMethodType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import sklearn.Classifier;
import sklearn.EstimatorUtil;
import sklearn.ensemble.bagging.BaggingUtil;

public class BaggingClassifier
extends Classifier {
    public BaggingClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public boolean requiresContinuousInput() {
        Classifier baseEstimator = this.getBaseEstimator();
        return baseEstimator.requiresContinuousInput();
    }

    @Override
    public DataType getDataType() {
        Classifier baseEstimator = this.getBaseEstimator();
        return baseEstimator.getDataType();
    }

    @Override
    public OpType getOpType() {
        Classifier baseEstimator = this.getBaseEstimator();
        return baseEstimator.getOpType();
    }

    public MiningModel encodeModel(Schema schema) {
        List<? extends Classifier> estimators = this.getEstimators();
        List<List<Integer>> estimatorsFeatures = this.getEstimatorsFeatures();
        MultipleModelMethodType multipleModelMethod = MultipleModelMethodType.AVERAGE;
        for (Classifier classifier : estimators) {
            if (classifier.hasProbabilityDistribution()) continue;
            multipleModelMethod = MultipleModelMethodType.MAJORITY_VOTE;
            break;
        }
        MiningModel miningModel = BaggingUtil.encodeBagging(estimators, estimatorsFeatures, multipleModelMethod, MiningFunctionType.CLASSIFICATION, schema).setOutput(ModelUtil.createProbabilityOutput((Schema)schema));
        return miningModel;
    }

    @Override
    public Set<DefineFunction> encodeDefineFunctions() {
        Classifier baseEstimator = this.getBaseEstimator();
        return baseEstimator.encodeDefineFunctions();
    }

    public Classifier getBaseEstimator() {
        Object baseEstimator = this.get("base_estimator_");
        return EstimatorUtil.asClassifier(baseEstimator);
    }

    public List<? extends Classifier> getEstimators() {
        List estimators = (List)this.get("estimators_");
        return EstimatorUtil.asClassifierList(estimators);
    }

    public List<List<Integer>> getEstimatorsFeatures() {
        List estimatorsFeatures = (List)this.get("estimators_features_");
        return BaggingUtil.transformEstimatorsFeatures(estimatorsFeatures);
    }
}

