/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.bagging;

import java.util.List;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.MultipleModelMethodType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Schema;
import sklearn.EstimatorUtil;
import sklearn.Regressor;
import sklearn.ensemble.bagging.BaggingUtil;

public class BaggingRegressor
extends Regressor {
    public BaggingRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public boolean requiresContinuousInput() {
        Regressor baseEstimator = this.getBaseEstimator();
        return baseEstimator.requiresContinuousInput();
    }

    @Override
    public DataType getDataType() {
        Regressor baseEstimator = this.getBaseEstimator();
        return baseEstimator.getDataType();
    }

    @Override
    public OpType getOpType() {
        Regressor baseEstimator = this.getBaseEstimator();
        return baseEstimator.getOpType();
    }

    public MiningModel encodeModel(Schema schema) {
        List<? extends Regressor> estimators = this.getEstimators();
        List<List<Integer>> estimatorsFeatures = this.getEstimatorsFeatures();
        MiningModel miningModel = BaggingUtil.encodeBagging(estimators, estimatorsFeatures, MultipleModelMethodType.AVERAGE, MiningFunctionType.REGRESSION, schema);
        return miningModel;
    }

    @Override
    public Set<DefineFunction> encodeDefineFunctions() {
        Regressor baseEstimator = this.getBaseEstimator();
        return baseEstimator.encodeDefineFunctions();
    }

    public Regressor getBaseEstimator() {
        Object baseEstimator = this.get("base_estimator_");
        return EstimatorUtil.asRegressor(baseEstimator);
    }

    public List<? extends Regressor> getEstimators() {
        List estimators = (List)this.get("estimators_");
        return EstimatorUtil.asRegressorList(estimators);
    }

    public List<List<Integer>> getEstimatorsFeatures() {
        List estimatorsFeatures = (List)this.get("estimators_features_");
        return BaggingUtil.transformEstimatorsFeatures(estimatorsFeatures);
    }
}

