/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.gradient_boosting;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.MultipleModelMethodType;
import org.dmg.pmml.NumericPredictor;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.RegressionModel;
import org.dmg.pmml.RegressionTable;
import org.dmg.pmml.TreeModel;
import org.jpmml.converter.MiningModelUtil;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import sklearn.linear_model.RegressionModelUtil;
import sklearn.tree.DecisionTreeRegressor;
import sklearn.tree.TreeModelUtil;

public class GradientBoostingUtil {
    private GradientBoostingUtil() {
    }

    public static MiningModel encodeGradientBoosting(List<DecisionTreeRegressor> regressors, Number initialPrediction, Number learningRate, Schema schema) {
        ArrayList<Object> models = new ArrayList<Object>();
        FieldName sumField = FieldName.create((String)"sum");
        Schema segmentSchema = schema.toAnonymousSchema();
        List<TreeModel> treeModels = TreeModelUtil.encodeTreeModelSegmentation(regressors, MiningFunctionType.REGRESSION, schema);
        Output output = new Output().addOutputFields(new OutputField[]{ModelUtil.createPredictedField((FieldName)sumField)});
        MiningModel miningModel = new MiningModel(MiningFunctionType.REGRESSION, ModelUtil.createMiningSchema((Schema)segmentSchema)).setSegmentation(MiningModelUtil.createSegmentation((MultipleModelMethodType)MultipleModelMethodType.SUM, treeModels)).setOutput(output);
        models.add(miningModel);
        MiningField miningField = ModelUtil.createMiningField((FieldName)sumField);
        NumericPredictor numericPredictor = new NumericPredictor(miningField.getName(), ValueUtil.asDouble((Number)learningRate).doubleValue());
        RegressionTable regressionTable = RegressionModelUtil.encodeRegressionTable(numericPredictor, initialPrediction);
        MiningSchema miningSchema = new MiningSchema();
        FieldName targetField = schema.getTargetField();
        if (targetField != null) {
            miningSchema.addMiningFields(new MiningField[]{ModelUtil.createMiningField((FieldName)targetField, (FieldUsageType)FieldUsageType.TARGET)});
        }
        miningSchema.addMiningFields(new MiningField[]{miningField});
        RegressionModel regressionModel = new RegressionModel(MiningFunctionType.REGRESSION, miningSchema, null).addRegressionTables(new RegressionTable[]{regressionTable});
        models.add(regressionModel);
        MiningModel miningModel2 = new MiningModel(MiningFunctionType.REGRESSION, ModelUtil.createMiningSchema((Schema)schema)).setSegmentation(MiningModelUtil.createSegmentation((MultipleModelMethodType)MultipleModelMethodType.MODEL_CHAIN, models));
        return miningModel2;
    }
}

