/*
 * Decompiled with CFR 0.152.
 */
package sklearn.neighbors;

import java.util.List;
import org.dmg.pmml.ContinuousScoringMethodType;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.NearestNeighborModel;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Regressor;
import sklearn.neighbors.HasNeighbors;
import sklearn.neighbors.HasTrainingData;
import sklearn.neighbors.KNeighborsUtil;

public class KNeighborsRegressor
extends Regressor
implements HasNeighbors,
HasTrainingData {
    public KNeighborsRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getFitXShape();
        return shape[1];
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public NearestNeighborModel encodeModel(Schema schema) {
        int[] shape = this.getFitXShape();
        int numberOfInstances = shape[0];
        int numberOfFeatures = shape[1];
        NearestNeighborModel nearestNeighborModel = KNeighborsUtil.encodeNeighbors(this, MiningFunctionType.REGRESSION, numberOfInstances, numberOfFeatures, schema).setContinuousScoringMethod(ContinuousScoringMethodType.AVERAGE);
        return nearestNeighborModel;
    }

    @Override
    public int getNumberOfNeighbors() {
        return ValueUtil.asInt((Number)((Number)this.get("n_neighbors")));
    }

    @Override
    public String getWeights() {
        return (String)this.get("weights");
    }

    @Override
    public String getMetric() {
        return (String)this.get("metric");
    }

    @Override
    public int getP() {
        return ValueUtil.asInt((Number)((Number)this.get("p")));
    }

    public List<? extends Number> getY() {
        return ClassDictUtil.getArray(this, "_y");
    }

    @Override
    public List<? extends Number> getFitX() {
        return ClassDictUtil.getArray(this, "_fit_X");
    }

    private int[] getFitXShape() {
        return ClassDictUtil.getShape(this, "_fit_X", 2);
    }
}

