/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import numpy.core.UFunc;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.FeatureMapper;
import sklearn.Transformer;

public class FunctionTransformer
extends Transformer {
    public FunctionTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> inputFeatures, FeatureMapper featureMapper) {
        UFunc ufunc;
        Object func = this.getFunc();
        if (ids.size() != inputFeatures.size()) {
            throw new IllegalArgumentException();
        }
        try {
            ufunc = (UFunc)((Object)func);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("The function object (" + ClassDictUtil.formatClass(func) + ") is not a Numpy universal function", cce);
        }
        String function = FunctionTransformer.parseUFunc(ufunc);
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < inputFeatures.size(); ++i) {
            String id = ids.get(i);
            Feature inputFeature = inputFeatures.get(i);
            Apply apply = PMMLUtil.createApply((String)function, (Expression[])new Expression[]{inputFeature.ref()});
            DerivedField derivedField = featureMapper.createDerivedField(FieldName.create((String)(function + "(" + id + ")")), (Expression)apply);
            features.add((Feature)new ContinuousFeature((TypeDefinitionField)derivedField));
        }
        return features;
    }

    public Object getFunc() {
        return this.get("func");
    }

    private static String parseUFunc(UFunc ufunc) {
        String module = ufunc.getModule();
        String name = ufunc.getName();
        switch (module) {
            case "numpy": 
            case "numpy.core.numeric": 
            case "numpy.lib.function_base": {
                switch (name) {
                    case "absolute": {
                        return "abs";
                    }
                    case "exp": {
                        return name;
                    }
                    case "log": {
                        return "ln";
                    }
                    case "log10": 
                    case "sqrt": {
                        return name;
                    }
                }
                throw new IllegalArgumentException(name);
            }
        }
        throw new IllegalArgumentException(module);
    }
}

