/*
 * Decompiled with CFR 0.152.
 */
package sklearn.svm;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.Coefficient;
import org.dmg.pmml.Coefficients;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Kernel;
import org.dmg.pmml.LinearKernel;
import org.dmg.pmml.PolynomialKernel;
import org.dmg.pmml.RadialBasisKernel;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.SigmoidKernel;
import org.dmg.pmml.SupportVector;
import org.dmg.pmml.SupportVectorMachine;
import org.dmg.pmml.SupportVectors;
import org.dmg.pmml.VectorDictionary;
import org.dmg.pmml.VectorFields;
import org.dmg.pmml.VectorInstance;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.LoggerUtil;
import org.jpmml.sklearn.MatrixUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportVectorMachineUtil {
    private static final Logger logger = LoggerFactory.getLogger(SupportVectorMachineUtil.class);

    private SupportVectorMachineUtil() {
    }

    public static VectorDictionary encodeVectorDictionary(List<Integer> support, List<? extends Number> supportVectors, int numberOfVectors, int numberOfFeatures, Schema schema) {
        BitSet features = new BitSet(numberOfFeatures);
        Double defaultValue = 0.0;
        for (int i = 0; i < numberOfVectors; ++i) {
            List<? extends Number> values = MatrixUtil.getRow(supportVectors, numberOfVectors, numberOfFeatures, i);
            BitSet vectorFeatures = ValueUtil.getIndices(values, (Number)defaultValue);
            vectorFeatures.flip(0, numberOfFeatures);
            features.or(vectorFeatures);
        }
        int numberOfUsedFeatures = features.cardinality();
        ArrayList<Feature> unusedFeatures = new ArrayList<Feature>();
        VectorFields vectorFields = new VectorFields();
        for (int i = 0; i < numberOfFeatures; ++i) {
            Feature feature = schema.getFeature(i);
            if (!features.get(i)) {
                unusedFeatures.add(feature);
                continue;
            }
            vectorFields.addFieldRefs(new FieldRef[]{feature.ref()});
        }
        VectorDictionary vectorDictionary = new VectorDictionary(vectorFields);
        for (int i = 0; i < numberOfVectors; ++i) {
            String id = String.valueOf(support.get(i));
            VectorInstance vectorInstance = new VectorInstance(id);
            List values = MatrixUtil.getRow(supportVectors, numberOfVectors, numberOfFeatures, i);
            if (numberOfUsedFeatures < numberOfFeatures) {
                values = ValueUtil.filterByIndices(values, (BitSet)features);
            }
            if (ValueUtil.isSparse((List)values, (Number)defaultValue, (double)0.75)) {
                RealSparseArray sparseArray = PMMLUtil.createRealSparseArray((List)values, (Double)defaultValue);
                vectorInstance.setRealSparseArray(sparseArray);
            } else {
                Array array = PMMLUtil.createRealArray((List)values);
                vectorInstance.setArray(array);
            }
            vectorDictionary.addVectorInstances(new VectorInstance[]{vectorInstance});
        }
        if (!unusedFeatures.isEmpty()) {
            logger.info("Skipped {} feature(s): {}", (Object)unusedFeatures.size(), (Object)LoggerUtil.formatNameList(unusedFeatures));
        }
        return vectorDictionary;
    }

    public static SupportVectorMachine encodeSupportVectorMachine(List<VectorInstance> vectorInstances, List<? extends Number> dualCoef, Number intercept) {
        if (vectorInstances.size() != dualCoef.size()) {
            throw new IllegalArgumentException();
        }
        Coefficients coefficients = new Coefficients().setAbsoluteValue(ValueUtil.asDouble((Number)intercept));
        SupportVectors supportVectors = new SupportVectors();
        for (int i = 0; i < vectorInstances.size(); ++i) {
            VectorInstance vectorInstance = vectorInstances.get(i);
            Coefficient coefficient = new Coefficient().setValue(ValueUtil.asDouble((Number)dualCoef.get(i)));
            coefficients.addCoefficients(new Coefficient[]{coefficient});
            SupportVector supportVector = new SupportVector(vectorInstance.getId());
            supportVectors.addSupportVectors(new SupportVector[]{supportVector});
        }
        SupportVectorMachine supportVectorMachine = new SupportVectorMachine(coefficients).setSupportVectors(supportVectors);
        return supportVectorMachine;
    }

    public static Kernel encodeKernel(String kernel, Integer degree, Double gamma, Double coef0) {
        switch (kernel) {
            case "linear": {
                return new LinearKernel();
            }
            case "poly": {
                return new PolynomialKernel().setDegree(ValueUtil.asDouble((Number)degree)).setCoef0(coef0).setGamma(gamma);
            }
            case "rbf": {
                return new RadialBasisKernel().setGamma(gamma);
            }
            case "sigmoid": {
                return new SigmoidKernel().setCoef0(coef0).setGamma(gamma);
            }
        }
        throw new IllegalArgumentException(kernel);
    }
}

