/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.FeatureMapper;
import sklearn.Transformer;

public class MinMaxScaler
extends Transformer {
    public MinMaxScaler(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> inputFeatures, FeatureMapper featureMapper) {
        List<? extends Number> min = this.getMin();
        List<? extends Number> scale = this.getScale();
        if (ids.size() != inputFeatures.size() || min.size() != inputFeatures.size() || scale.size() != inputFeatures.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < inputFeatures.size(); ++i) {
            String id = ids.get(i);
            Feature inputFeature = inputFeatures.get(i);
            Number minValue = min.get(i);
            Number scaleValue = scale.get(i);
            FieldRef expression = inputFeature.ref();
            if (!ValueUtil.isOne((Number)scaleValue)) {
                expression = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)scaleValue)});
            }
            if (!ValueUtil.isZero((Number)minValue)) {
                expression = PMMLUtil.createApply((String)"+", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)minValue)});
            }
            if (expression instanceof FieldRef) {
                features.add(inputFeature);
                continue;
            }
            DerivedField derivedField = featureMapper.createDerivedField(this.createName(id), (Expression)expression);
            features.add((Feature)new ContinuousFeature((TypeDefinitionField)derivedField));
        }
        return features;
    }

    public List<? extends Number> getMin() {
        return ClassDictUtil.getArray(this, "min_");
    }

    public List<? extends Number> getScale() {
        return ClassDictUtil.getArray(this, "scale_");
    }
}

