/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldDecorator;
import org.jpmml.converter.ValidValueDecorator;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.FeatureMapper;
import sklearn2pmml.decoration.Domain;
import sklearn2pmml.decoration.DomainUtil;

public class ContinuousDomain
extends Domain {
    public ContinuousDomain(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> inputFeatures, FeatureMapper featureMapper) {
        List<? extends Number> dataMin = this.getDataMin();
        List<? extends Number> dataMax = this.getDataMax();
        if (ids.size() != inputFeatures.size() || dataMin.size() != inputFeatures.size() || dataMax.size() != inputFeatures.size()) {
            throw new IllegalArgumentException();
        }
        final InvalidValueTreatmentMethod invalidValueTreatment = DomainUtil.parseInvalidValueTreatment(this.getInvalidValueTreatment());
        for (int i = 0; i < inputFeatures.size(); ++i) {
            WildcardFeature inputFeature = (WildcardFeature)inputFeatures.get(i);
            final Interval interval = new Interval(Interval.Closure.CLOSED_CLOSED).setLeftMargin(ValueUtil.asDouble((Number)dataMin.get(i))).setRightMargin(ValueUtil.asDouble((Number)dataMax.get(i)));
            ValidValueDecorator decorator = new ValidValueDecorator(){
                {
                    this.setInvalidValueTreatment(invalidValueTreatment);
                }

                public void decorate(DataField dataField, MiningField miningField) {
                    DataType dataType = dataField.getDataType();
                    switch (dataType) {
                        case FLOAT: {
                            interval.setLeftMargin(this.toFloat(interval.getLeftMargin()));
                            interval.setRightMargin(this.toFloat(interval.getRightMargin()));
                            break;
                        }
                    }
                    dataField.addIntervals(new Interval[]{interval});
                    super.decorate(dataField, miningField);
                }

                private Double toFloat(Double value) {
                    if (value != null && value != (double)value.floatValue()) {
                        return value.floatValue();
                    }
                    return value;
                }
            };
            featureMapper.addDecorator(inputFeature.getName(), (FieldDecorator)decorator);
        }
        return inputFeatures;
    }

    public List<? extends Number> getDataMin() {
        return ClassDictUtil.getArray(this, "data_min_");
    }

    public List<? extends Number> getDataMax() {
        return ClassDictUtil.getArray(this, "data_max_");
    }
}

