/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.gradient_boosting;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Regressor;
import sklearn.ensemble.gradient_boosting.GradientBoostingUtil;
import sklearn.ensemble.gradient_boosting.HasDefaultValue;
import sklearn.tree.DecisionTreeRegressor;

public class GradientBoostingRegressor
extends Regressor {
    public GradientBoostingRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        return ValueUtil.asInt((Number)((Number)this.get("n_features")));
    }

    @Override
    public boolean requiresContinuousInput() {
        return false;
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public MiningModel encodeModel(Schema schema) {
        HasDefaultValue init = this.getInit();
        List<DecisionTreeRegressor> estimators = this.getEstimators();
        return GradientBoostingUtil.encodeGradientBoosting(estimators, init.getDefaultValue(), this.getLearningRate(), schema);
    }

    public HasDefaultValue getInit() {
        Object init = this.get("init_");
        try {
            if (init == null) {
                throw new NullPointerException();
            }
            return (HasDefaultValue)init;
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("The estimator object (" + ClassDictUtil.formatClass(init) + ") is not a BaseEstimator or is not a supported BaseEstimator subclass", re);
        }
    }

    public Number getLearningRate() {
        return (Number)this.get("learning_rate");
    }

    public List<DecisionTreeRegressor> getEstimators() {
        return ClassDictUtil.getArray(this, "estimators_");
    }
}

