/*
 * Decompiled with CFR 0.152.
 */
package sklearn.linear_model;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.LoggerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegressionModelUtil {
    private static final Logger logger = LoggerFactory.getLogger(RegressionModelUtil.class);

    private RegressionModelUtil() {
    }

    public static RegressionModel encodeRegressionModel(List<? extends Number> coefficients, Number intercept, Schema schema) {
        RegressionTable regressionTable = RegressionModelUtil.encodeRegressionTable(coefficients, intercept, schema);
        RegressionModel regressionModel = new RegressionModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Schema)schema), null).addRegressionTables(new RegressionTable[]{regressionTable});
        return regressionModel;
    }

    public static RegressionTable encodeRegressionTable(List<? extends Number> coefficients, Number intercept, Schema schema) {
        List features = schema.getFeatures();
        if (coefficients.size() != features.size()) {
            throw new IllegalArgumentException();
        }
        RegressionTable regressionTable = new RegressionTable(ValueUtil.asDouble((Number)intercept).doubleValue());
        ArrayList<Feature> unusedFeatures = new ArrayList<Feature>();
        for (int i = 0; i < coefficients.size(); ++i) {
            Number coefficient = coefficients.get(i);
            Feature feature = (Feature)features.get(i);
            if (ValueUtil.isZero((Number)coefficient)) {
                unusedFeatures.add(feature);
                continue;
            }
            if (feature instanceof ContinuousFeature) {
                ContinuousFeature continuousFeature = (ContinuousFeature)feature;
                NumericPredictor numericPredictor = new NumericPredictor(continuousFeature.getName(), ValueUtil.asDouble((Number)coefficient).doubleValue());
                regressionTable.addNumericPredictors(new NumericPredictor[]{numericPredictor});
                continue;
            }
            if (feature instanceof BinaryFeature) {
                BinaryFeature binaryFeature = (BinaryFeature)feature;
                CategoricalPredictor categoricalPredictor = new CategoricalPredictor(binaryFeature.getName(), binaryFeature.getValue(), ValueUtil.asDouble((Number)coefficient).doubleValue());
                regressionTable.addCategoricalPredictors(new CategoricalPredictor[]{categoricalPredictor});
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (!unusedFeatures.isEmpty()) {
            logger.info("Skipped {} feature(s): {}", (Object)unusedFeatures.size(), (Object)LoggerUtil.formatNameList(unusedFeatures));
        }
        return regressionTable;
    }

    public static RegressionTable encodeRegressionTable(NumericPredictor numericPredictor, Number intercept) {
        RegressionTable regressionTable = new RegressionTable(ValueUtil.asDouble((Number)intercept).doubleValue()).addNumericPredictors(new NumericPredictor[]{numericPredictor});
        return regressionTable;
    }
}

