/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldDecorator;
import org.jpmml.converter.MissingValueDecorator;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.FeatureMapper;
import sklearn.Transformer;

public class Imputer
extends Transformer {
    public Imputer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> inputFeatures, FeatureMapper featureMapper) {
        List<? extends Number> statistics = this.getStatistics();
        if (ids.size() != inputFeatures.size() || statistics.size() != inputFeatures.size()) {
            throw new IllegalArgumentException();
        }
        Object missingValues = this.getMissingValues();
        Number targetValue = Imputer.getTargetValue(missingValues);
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < inputFeatures.size(); ++i) {
            String id = ids.get(i);
            Feature inputFeature = inputFeatures.get(i);
            Number statisticValue = statistics.get(i);
            if (inputFeature instanceof WildcardFeature) {
                String strategy = this.getStrategy();
                MissingValueDecorator decorator = new MissingValueDecorator().setMissingValueReplacement(ValueUtil.formatValue((Number)statisticValue)).setMissingValueTreatment(Imputer.parseStrategy(strategy));
                if (targetValue != null) {
                    decorator.addMissingValues(new String[]{ValueUtil.formatValue((Number)targetValue)});
                }
                featureMapper.addDecorator(inputFeature.getName(), (FieldDecorator)decorator);
                features.add(inputFeature);
                continue;
            }
            FieldRef expression = inputFeature.ref();
            expression = targetValue == null ? PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{expression}) : PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)targetValue)});
            expression = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)statisticValue), inputFeature.ref()});
            DerivedField derivedField = featureMapper.createDerivedField(this.createName(id), (Expression)expression);
            features.add((Feature)new ContinuousFeature((TypeDefinitionField)derivedField));
        }
        return features;
    }

    public Object getMissingValues() {
        return this.get("missing_values");
    }

    public List<? extends Number> getStatistics() {
        return ClassDictUtil.getArray(this, "statistics_");
    }

    public String getStrategy() {
        return (String)this.get("strategy");
    }

    private static Number getTargetValue(Object object) {
        if (object instanceof String) {
            return null;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new IllegalArgumentException();
    }

    private static MissingValueTreatmentMethod parseStrategy(String strategy) {
        switch (strategy) {
            case "mean": {
                return MissingValueTreatmentMethod.AS_MEAN;
            }
            case "median": {
                return MissingValueTreatmentMethod.AS_MEDIAN;
            }
            case "most_frequent": {
                return MissingValueTreatmentMethod.AS_MODE;
            }
        }
        throw new IllegalArgumentException(strategy);
    }
}

